/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.j2k.ast.AnonymousClass;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.util.AstUtil;

public class NewClassExpression
extends Expression {
    private final Element myName;
    private final List<Expression> myArguments;
    private Expression myQualifier;
    private List<String> myConversions;
    @Nullable
    private AnonymousClass myAnonymousClass = null;

    private NewClassExpression(Element name, List<Expression> arguments) {
        this.myName = name;
        this.myQualifier = EMPTY_EXPRESSION;
        this.myArguments = arguments;
        this.myConversions = AstUtil.createListWithEmptyString(arguments);
    }

    public NewClassExpression(@NotNull Expression qualifier, @NotNull Element name, @NotNull List<Expression> arguments, @NotNull List<String> conversions, @Nullable AnonymousClass anonymousClass) {
        this(name, arguments);
        this.myQualifier = qualifier;
        this.myConversions = conversions;
        this.myAnonymousClass = anonymousClass;
    }

    @Override
    @NotNull
    public String toKotlin() {
        String callOperator = this.myQualifier.isNullable() ? "?." : ".";
        String qualifier = this.myQualifier.isEmpty() ? "" : this.myQualifier.toKotlin() + callOperator;
        List<String> applyConversions = AstUtil.applyConversions(AstUtil.nodesToKotlin(this.myArguments), this.myConversions);
        String appliedArguments = AstUtil.join(applyConversions, ", ");
        return this.myAnonymousClass != null ? "object : " + qualifier + this.myName.toKotlin() + "(" + appliedArguments + ")" + this.myAnonymousClass.toKotlin() : qualifier + this.myName.toKotlin() + "(" + appliedArguments + ")";
    }
}

