/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.util.AstUtil;

public class MethodCallExpression
extends Expression {
    private final Expression myMethodCall;
    private final List<Expression> myArguments;
    private final List<String> myConversions;
    private final boolean myIsResultNullable;
    private final List<Type> myTypeParameters;

    public MethodCallExpression(Expression methodCall, List<Expression> arguments, List<Type> typeParameters) {
        this(methodCall, arguments, AstUtil.createListWithEmptyString(arguments), false, typeParameters);
    }

    public MethodCallExpression(Expression methodCall, List<Expression> arguments, List<String> conversions, boolean nullable, List<Type> typeParameters) {
        this.myMethodCall = methodCall;
        this.myArguments = arguments;
        this.myConversions = conversions;
        this.myIsResultNullable = nullable;
        this.myTypeParameters = typeParameters;
    }

    @Override
    public boolean isNullable() {
        return this.myIsResultNullable;
    }

    @Override
    @NotNull
    public String toKotlin() {
        String typeParamsToKotlin = this.myTypeParameters.size() > 0 ? "<" + AstUtil.joinNodes(this.myTypeParameters, ", ") + ">" : "";
        List<String> applyConversions = AstUtil.applyConversions(AstUtil.nodesToKotlin(this.myArguments), this.myConversions);
        return this.myMethodCall.toKotlin() + typeParamsToKotlin + "(" + AstUtil.join(applyConversions, ", ") + ")";
    }
}

