/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.Type;

public class LocalVariable
extends Expression {
    private final Identifier myIdentifier;
    private final Set<String> myModifiersSet;
    private final Type myType;
    private final Expression myInitializer;

    public LocalVariable(Identifier identifier, Set<String> modifiersSet, Type type, Expression initializer) {
        this.myIdentifier = identifier;
        this.myModifiersSet = modifiersSet;
        this.myType = type;
        this.myInitializer = initializer;
    }

    public boolean hasModifier(String modifier) {
        return this.myModifiersSet.contains(modifier);
    }

    @Override
    @NotNull
    public String toKotlin() {
        if (this.myInitializer.isEmpty()) {
            return this.myIdentifier.toKotlin() + " " + ":" + " " + this.myType.toKotlin();
        }
        return this.myIdentifier.toKotlin() + " " + ":" + " " + this.myType.toKotlin() + " " + "=" + " " + this.myInitializer.toKotlin();
    }
}

