/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.Statement;

public class IfStatement
extends Expression {
    private final Expression myCondition;
    private final Statement myThenStatement;
    private final Statement myElseStatement;

    public IfStatement(Expression condition, Statement thenStatement, Statement elseStatement) {
        this.myCondition = condition;
        this.myThenStatement = thenStatement;
        this.myElseStatement = elseStatement;
    }

    @Override
    @NotNull
    public String toKotlin() {
        String result = "if (" + this.myCondition.toKotlin() + ")" + "\n" + this.myThenStatement.toKotlin() + "\n";
        if (this.myElseStatement != Statement.EMPTY_STATEMENT) {
            return result + "else" + "\n" + this.myElseStatement.toKotlin();
        }
        return result;
    }
}

