/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.Identifier;

public class IdentifierImpl
extends Expression
implements Identifier {
    private final String myName;
    private boolean myIsNullable = true;
    private boolean myQuotingNeeded = true;

    public IdentifierImpl(String name) {
        this.myName = name;
    }

    public IdentifierImpl(String name, boolean isNullable) {
        this.myName = name;
        this.myIsNullable = isNullable;
    }

    public IdentifierImpl(String name, boolean isNullable, boolean quotingNeeded) {
        this.myName = name;
        this.myIsNullable = isNullable;
        this.myQuotingNeeded = quotingNeeded;
    }

    @Override
    public boolean isEmpty() {
        return this.myName.length() == 0;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @NotNull
    private static String quote(String str) {
        return "`" + str + "`";
    }

    @Override
    public boolean isNullable() {
        return this.myIsNullable;
    }

    private String ifNeedQuote() {
        if (this.myQuotingNeeded && (ONLY_KOTLIN_KEYWORDS.contains(this.myName) || this.myName.contains("$"))) {
            return IdentifierImpl.quote(this.myName);
        }
        return this.myName;
    }

    @Override
    @NotNull
    public String toKotlin() {
        return this.ifNeedQuote();
    }
}

