/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Block;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.Member;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.ast.TypeParameter;
import org.jetbrains.jet.j2k.util.AstUtil;

public class Function
extends Member {
    private final Identifier myName;
    private final Type myType;
    private final List<Element> myTypeParameters;
    final Element myParams;
    Block myBlock;

    public void setBlock(Block block) {
        this.myBlock = block;
    }

    public Function(Identifier name, Set<String> modifiers, Type type, List<Element> typeParameters, Element params, Block block) {
        this.myName = name;
        this.myModifiers = modifiers;
        this.myType = type;
        this.myTypeParameters = typeParameters;
        this.myParams = params;
        this.myBlock = block;
    }

    public List<Element> getTypeParameters() {
        return this.myTypeParameters;
    }

    public Element getParams() {
        return this.myParams;
    }

    public Block getBlock() {
        return this.myBlock;
    }

    @NotNull
    private String typeParametersToKotlin() {
        return this.myTypeParameters.size() > 0 ? "<" + AstUtil.joinNodes(this.myTypeParameters, ", ") + ">" : "";
    }

    private boolean hasWhere() {
        for (Element t : this.myTypeParameters) {
            if (!(t instanceof TypeParameter) || !((TypeParameter)t).hasWhere()) continue;
            return true;
        }
        return false;
    }

    private String typeParameterWhereToKotlin() {
        if (this.hasWhere()) {
            LinkedList<String> wheres = new LinkedList<String>();
            for (Element t : this.myTypeParameters) {
                if (!(t instanceof TypeParameter)) continue;
                wheres.add(((TypeParameter)t).getWhereToKotlin());
            }
            return " where " + AstUtil.join(wheres, ", ") + " ";
        }
        return "";
    }

    String modifiersToKotlin() {
        LinkedList<String> modifierList = new LinkedList<String>();
        String accessModifier = this.accessModifier();
        if (!accessModifier.isEmpty()) {
            modifierList.add(accessModifier);
        }
        if (this.isAbstract()) {
            modifierList.add("abstract");
        }
        if (this.myModifiers.contains("override")) {
            modifierList.add("override");
        }
        if (!(this.myModifiers.contains("abstract") || this.myModifiers.contains("override") || this.myModifiers.contains("final"))) {
            modifierList.add("open");
        }
        if (this.myModifiers.contains("not open")) {
            modifierList.remove("open");
        }
        if (modifierList.size() > 0) {
            return AstUtil.join(modifierList, " ") + " ";
        }
        return "";
    }

    @Override
    @NotNull
    public String toKotlin() {
        return this.modifiersToKotlin() + "fun" + " " + this.myName.toKotlin() + this.typeParametersToKotlin() + "(" + this.myParams.toKotlin() + ")" + " " + ":" + " " + this.myType.toKotlin() + " " + this.typeParameterWhereToKotlin() + this.myBlock.toKotlin();
    }
}

