/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Class;
import org.jetbrains.jet.j2k.ast.Import;
import org.jetbrains.jet.j2k.ast.Node;
import org.jetbrains.jet.j2k.util.AstUtil;

public class File
extends Node {
    private final String myPackageName;
    private final List<Import> myImports;
    private final List<Class> myClasses;
    private final String myMainFunction;

    public File(String packageName, List<Import> imports, List<Class> classes, String mainFunction) {
        this.myPackageName = packageName;
        this.myImports = imports;
        this.myClasses = classes;
        this.myMainFunction = mainFunction;
    }

    @Override
    @NotNull
    public String toKotlin() {
        String common = AstUtil.joinNodes(this.myImports, "\n") + "\n\n" + AstUtil.joinNodes(this.myClasses, "\n") + "\n" + this.myMainFunction;
        if (this.myPackageName.isEmpty()) {
            return common;
        }
        return "package " + this.myPackageName + "\n" + common;
    }
}

