/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.Converter;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.Member;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.util.AstUtil;

public class Field
extends Member {
    final Identifier myIdentifier;
    private final int myWritingAccesses;
    final Type myType;
    final Element myInitializer;

    public Field(Identifier identifier, Set<String> modifiers, Type type, Element initializer, int writingAccesses) {
        this.myIdentifier = identifier;
        this.myWritingAccesses = writingAccesses;
        this.myModifiers = modifiers;
        this.myType = type;
        this.myInitializer = initializer;
    }

    public Element getInitializer() {
        return this.myInitializer;
    }

    public Identifier getIdentifier() {
        return this.myIdentifier;
    }

    public Type getType() {
        return this.myType;
    }

    @NotNull
    String modifiersToKotlin() {
        LinkedList<String> modifierList = new LinkedList<String>();
        if (this.isAbstract()) {
            modifierList.add("abstract");
        }
        modifierList.add(this.accessModifier());
        modifierList.add(this.isVal() ? "val" : "var");
        if (modifierList.size() > 0) {
            return AstUtil.join(modifierList, " ") + " ";
        }
        return "";
    }

    public boolean isVal() {
        return this.myModifiers.contains("final");
    }

    @Override
    public boolean isStatic() {
        return this.myModifiers.contains("static");
    }

    @Override
    @NotNull
    public String toKotlin() {
        String declaration = this.modifiersToKotlin() + this.myIdentifier.toKotlin() + " " + ":" + " " + this.myType.toKotlin();
        if (this.myInitializer.isEmpty()) {
            return declaration + (this.isVal() && !this.isStatic() && this.myWritingAccesses == 1 ? "" : " = " + Converter.getDefaultInitializer(this));
        }
        return declaration + " " + "=" + " " + this.myInitializer.toKotlin();
    }
}

