/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.LocalVariable;
import org.jetbrains.jet.j2k.ast.Statement;
import org.jetbrains.jet.j2k.util.AstUtil;

public class DeclarationStatement
extends Statement {
    private final List<Element> myElements;

    public DeclarationStatement(List<Element> elements) {
        this.myElements = elements;
    }

    @NotNull
    private static List<String> toStringList(@NotNull List<Element> elements) {
        LinkedList<String> result = new LinkedList<String>();
        for (Element e : elements) {
            if (!(e instanceof LocalVariable)) continue;
            LocalVariable v = (LocalVariable)e;
            String varKeyword = v.hasModifier("final") ? "val" : "var";
            result.add(varKeyword + " " + e.toKotlin());
        }
        return result;
    }

    @Override
    @NotNull
    public String toKotlin() {
        return AstUtil.join(DeclarationStatement.toStringList(this.myElements), "\n");
    }
}

