/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Block;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.Function;
import org.jetbrains.jet.j2k.ast.INode;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.Type;

public class Constructor
extends Function {
    private final boolean myIsPrimary;

    public Constructor(Identifier identifier, Set<String> modifiers, Type type, List<Element> typeParameters, Element params, Block block, boolean isPrimary) {
        super(identifier, modifiers, type, typeParameters, params, block);
        this.myIsPrimary = isPrimary;
    }

    @NotNull
    public String primarySignatureToKotlin() {
        return "(" + this.myParams.toKotlin() + ")";
    }

    @NotNull
    public String primaryBodyToKotlin() {
        return this.myBlock.toKotlin();
    }

    public boolean isPrimary() {
        return this.myIsPrimary;
    }

    @Override
    @NotNull
    public INode.Kind getKind() {
        return INode.Kind.CONSTRUCTOR;
    }
}

