/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.util.AstUtil;

public class ClassType
extends Type {
    private final Identifier myType;
    private final List<? extends Element> myParameters;

    public ClassType(Identifier type, List<? extends Element> parameters, boolean nullable) {
        this.myType = type;
        this.myParameters = parameters;
        this.myNullable = nullable;
    }

    public ClassType(Identifier type, List<? extends Element> parameters) {
        this.myType = type;
        this.myParameters = parameters;
    }

    public ClassType(Identifier type) {
        this.myType = type;
        this.myNullable = false;
        this.myParameters = Collections.emptyList();
    }

    @Override
    @NotNull
    public String toKotlin() {
        String params = this.myParameters.size() == 0 ? "" : "<" + AstUtil.joinNodes(this.myParameters, ", ") + ">";
        return this.myType.toKotlin() + params + this.isNullableStr();
    }
}

