/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.j2k.Converter;
import org.jetbrains.jet.j2k.J2KConverterFlags;
import org.jetbrains.jet.j2k.ast.Block;
import org.jetbrains.jet.j2k.ast.ClassType;
import org.jetbrains.jet.j2k.ast.Constructor;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.Function;
import org.jetbrains.jet.j2k.ast.INode;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.IdentifierImpl;
import org.jetbrains.jet.j2k.ast.Member;
import org.jetbrains.jet.j2k.ast.ReturnStatement;
import org.jetbrains.jet.j2k.ast.Statement;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.ast.TypeParameter;
import org.jetbrains.jet.j2k.util.AstUtil;

public class Class
extends Member {
    @NotNull
    String TYPE = "class";
    final Identifier myName;
    private final List<Expression> myBaseClassParams;
    private final List<Member> myMembers;
    private final List<Element> myTypeParameters;
    private final List<Type> myExtendsTypes;
    private final List<Type> myImplementsTypes;

    public Class(Converter converter, Identifier name, Set<String> modifiers, List<Element> typeParameters, List<Type> extendsTypes, List<Expression> baseClassParams, List<Type> implementsTypes, List<Member> members) {
        this.myName = name;
        this.myBaseClassParams = baseClassParams;
        this.myModifiers = modifiers;
        this.myTypeParameters = typeParameters;
        this.myExtendsTypes = extendsTypes;
        this.myImplementsTypes = implementsTypes;
        this.myMembers = Class.getMembers(members, converter);
    }

    static List<Member> getMembers(List<Member> members, Converter converter) {
        LinkedList<Member> withoutPrivate = new LinkedList();
        if (converter.hasFlag(J2KConverterFlags.SKIP_NON_PUBLIC_MEMBERS)) {
            for (Member m : members) {
                if (!m.accessModifier().equals("public") && !m.accessModifier().equals("protected")) continue;
                withoutPrivate.add(m);
            }
        } else {
            withoutPrivate = members;
        }
        return withoutPrivate;
    }

    @Nullable
    private Constructor getPrimaryConstructor() {
        for (Member m : this.myMembers) {
            if (m.getKind() != INode.Kind.CONSTRUCTOR || !((Constructor)m).isPrimary()) continue;
            return (Constructor)m;
        }
        return null;
    }

    String primaryConstructorSignatureToKotlin() {
        Constructor maybeConstructor = this.getPrimaryConstructor();
        if (maybeConstructor != null) {
            return maybeConstructor.primarySignatureToKotlin();
        }
        return "()";
    }

    String primaryConstructorBodyToKotlin() {
        Constructor maybeConstructor = this.getPrimaryConstructor();
        if (maybeConstructor != null && !maybeConstructor.getBlock().isEmpty()) {
            return maybeConstructor.primaryBodyToKotlin();
        }
        return "";
    }

    private boolean hasWhere() {
        for (Element t : this.myTypeParameters) {
            if (!(t instanceof TypeParameter) || !((TypeParameter)t).hasWhere()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    String typeParameterWhereToKotlin() {
        if (this.hasWhere()) {
            LinkedList<String> wheres = new LinkedList<String>();
            for (Element t : this.myTypeParameters) {
                if (!(t instanceof TypeParameter)) continue;
                wheres.add(((TypeParameter)t).getWhereToKotlin());
            }
            return " where " + AstUtil.join(wheres, ", ") + " ";
        }
        return "";
    }

    @NotNull
    LinkedList<Member> membersExceptConstructors() {
        LinkedList<Member> result = new LinkedList<Member>();
        for (Member m : this.myMembers) {
            if (m.getKind() == INode.Kind.CONSTRUCTOR) continue;
            result.add(m);
        }
        return result;
    }

    @NotNull
    List<Function> secondaryConstructorsAsStaticInitFunction() {
        LinkedList<Function> result = new LinkedList<Function>();
        for (Member m : this.myMembers) {
            if (m.getKind() != INode.Kind.CONSTRUCTOR || ((Constructor)m).isPrimary()) continue;
            Function f = (Function)m;
            HashSet<String> modifiers = new HashSet<String>(m.myModifiers);
            modifiers.add("static");
            List<Statement> statements = f.getBlock().getStatements();
            statements.add(new ReturnStatement(new IdentifierImpl("__")));
            Block block = new Block(statements);
            LinkedList<Element> typeParameters = new LinkedList<Element>();
            if (f.getTypeParameters().size() == 0) {
                typeParameters.addAll(this.myTypeParameters);
            } else {
                typeParameters.addAll(this.myTypeParameters);
                typeParameters.addAll(f.getTypeParameters());
            }
            result.add(new Function(new IdentifierImpl("init"), modifiers, new ClassType(this.myName, typeParameters, false), typeParameters, f.getParams(), block));
        }
        return result;
    }

    @NotNull
    String typeParametersToKotlin() {
        return this.myTypeParameters.size() > 0 ? "<" + AstUtil.joinNodes(this.myTypeParameters, ", ") + ">" : "";
    }

    List<String> baseClassSignatureWithParams() {
        if (this.TYPE.equals("class") && this.myExtendsTypes.size() == 1) {
            LinkedList<String> result = new LinkedList<String>();
            result.add(this.myExtendsTypes.get(0).toKotlin() + "(" + AstUtil.joinNodes(this.myBaseClassParams, ", ") + ")");
            return result;
        }
        return AstUtil.nodesToKotlin(this.myExtendsTypes);
    }

    @NotNull
    String implementTypesToKotlin() {
        LinkedList<String> allTypes = new LinkedList<String>(){
            {
                this.addAll(Class.this.baseClassSignatureWithParams());
                this.addAll(AstUtil.nodesToKotlin(Class.this.myImplementsTypes));
            }
        };
        return allTypes.size() == 0 ? "" : " : " + AstUtil.join((List<String>)allTypes, ", ");
    }

    @NotNull
    String modifiersToKotlin() {
        LinkedList<String> modifierList = new LinkedList<String>();
        modifierList.add(this.accessModifier());
        if (this.needAbstractModifier()) {
            modifierList.add("abstract");
        }
        if (this.needOpenModifier()) {
            modifierList.add("open");
        }
        if (modifierList.size() > 0) {
            return AstUtil.join(modifierList, " ") + " ";
        }
        return "";
    }

    boolean needOpenModifier() {
        return !this.myModifiers.contains("final") && !this.myModifiers.contains("abstract");
    }

    boolean needAbstractModifier() {
        return this.isAbstract();
    }

    @NotNull
    String bodyToKotlin() {
        return " {\n" + AstUtil.joinNodes(Class.getNonStatic(this.membersExceptConstructors()), "\n") + "\n" + this.primaryConstructorBodyToKotlin() + "\n" + this.classObjectToKotlin() + "\n" + "}";
    }

    @NotNull
    private static List<Member> getStatic(@NotNull List<? extends Member> members) {
        LinkedList<Member> result = new LinkedList<Member>();
        for (Member member : members) {
            if (!member.isStatic()) continue;
            result.add(member);
        }
        return result;
    }

    @NotNull
    private static List<Member> getNonStatic(@NotNull List<? extends Member> members) {
        LinkedList<Member> result = new LinkedList<Member>();
        for (Member member : members) {
            if (member.isStatic()) continue;
            result.add(member);
        }
        return result;
    }

    @NotNull
    private String classObjectToKotlin() {
        LinkedList<Function> staticMembers = new LinkedList<Function>(this.secondaryConstructorsAsStaticInitFunction());
        staticMembers.addAll(Class.getStatic(this.membersExceptConstructors()));
        if (staticMembers.size() > 0) {
            return "class object {\n" + AstUtil.joinNodes(staticMembers, "\n") + "\n" + "}";
        }
        return "";
    }

    @Override
    @NotNull
    public String toKotlin() {
        return this.modifiersToKotlin() + this.TYPE + " " + this.myName.toKotlin() + this.typeParametersToKotlin() + this.primaryConstructorSignatureToKotlin() + this.implementTypesToKotlin() + this.typeParameterWhereToKotlin() + this.bodyToKotlin();
    }
}

