/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Block;
import org.jetbrains.jet.j2k.ast.INode;
import org.jetbrains.jet.j2k.ast.Statement;
import org.jetbrains.jet.j2k.util.AstUtil;

public class CaseContainer
extends Statement {
    private final List<Statement> myCaseStatement;
    private final Block myBlock;

    public CaseContainer(List<Statement> caseStatement, @NotNull List<Statement> statements) {
        this.myCaseStatement = caseStatement;
        LinkedList<Statement> newStatements = new LinkedList<Statement>();
        for (Statement s : statements) {
            if (s.getKind() == INode.Kind.BREAK || s.getKind() == INode.Kind.CONTINUE) continue;
            newStatements.add(s);
        }
        this.myBlock = new Block(newStatements);
    }

    @Override
    @NotNull
    public String toKotlin() {
        return AstUtil.joinNodes(this.myCaseStatement, ", ") + " " + "->" + " " + this.myBlock.toKotlin();
    }
}

