/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.INode;

public class CallChainExpression
extends Expression {
    private final Expression myExpression;
    private final Expression myIdentifier;

    public Expression getIdentifier() {
        return this.myIdentifier;
    }

    @Override
    @NotNull
    public INode.Kind getKind() {
        return INode.Kind.CALL_CHAIN;
    }

    public CallChainExpression(Expression expression, Expression identifier) {
        this.myExpression = expression;
        this.myIdentifier = identifier;
    }

    @Override
    public boolean isNullable() {
        return this.myIdentifier.isNullable();
    }

    @Override
    @NotNull
    public String toKotlin() {
        if (!this.myExpression.isEmpty()) {
            if (this.myExpression.isNullable()) {
                return this.myExpression.toKotlin() + "?." + this.myIdentifier.toKotlin();
            }
            return this.myExpression.toKotlin() + "." + this.myIdentifier.toKotlin();
        }
        return this.myIdentifier.toKotlin();
    }
}

