/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Statement;
import org.jetbrains.jet.j2k.util.AstUtil;

public class Block
extends Statement {
    @NotNull
    public static final Block EMPTY_BLOCK = new Block();
    private List<Statement> myStatements = new LinkedList<Statement>();
    private boolean myNotEmpty = false;

    private Block() {
    }

    public Block(List<Statement> statements) {
        this.myStatements = statements;
    }

    public Block(List<Statement> statements, boolean notEmpty) {
        this.myStatements = statements;
        this.myNotEmpty = notEmpty;
    }

    @Override
    public boolean isEmpty() {
        return !this.myNotEmpty && this.myStatements.size() == 0;
    }

    public List<Statement> getStatements() {
        return this.myStatements;
    }

    @Override
    @NotNull
    public String toKotlin() {
        if (!this.isEmpty()) {
            return "{\n" + AstUtil.joinNodes(this.myStatements, "\n") + "\n" + "}";
        }
        return "";
    }
}

