/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.util.AstUtil;

public class BinaryExpression
extends Expression {
    private final Expression myLeft;
    private final Expression myRight;
    private final String myOp;
    private final List<String> myConversions;

    public BinaryExpression(Expression left, Expression right, String op) {
        this(left, right, op, Arrays.asList("", ""));
    }

    public BinaryExpression(Expression left, Expression right, String op, List<String> conversions) {
        this.myLeft = left;
        this.myRight = right;
        this.myOp = op;
        this.myConversions = conversions;
    }

    @Override
    @NotNull
    public String toKotlin() {
        List<String> expressionsWithConversions = AstUtil.applyConversions(AstUtil.nodesToKotlin(Arrays.asList(this.myLeft, this.myRight)), this.myConversions);
        return AstUtil.join(expressionsWithConversions, " " + this.myOp + " ");
    }
}

