/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.ArrayType;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.INode;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.util.AstUtil;

public class ArrayWithoutInitializationExpression
extends Expression {
    private final Type myType;
    private final List<Expression> myExpressions;

    public ArrayWithoutInitializationExpression(Type type, List<Expression> expressions) {
        this.myType = type;
        this.myExpressions = expressions;
    }

    @Override
    @NotNull
    public String toKotlin() {
        if (this.myType.getKind() == INode.Kind.ARRAY_TYPE) {
            return ArrayWithoutInitializationExpression.constructInnerType((ArrayType)this.myType, this.myExpressions);
        }
        return ArrayWithoutInitializationExpression.getConstructorName(this.myType);
    }

    @NotNull
    private static String constructInnerType(@NotNull ArrayType hostType, @NotNull List<Expression> expressions) {
        if (expressions.size() == 1) {
            return ArrayWithoutInitializationExpression.oneDim(hostType, expressions.get(0));
        }
        Type innerType = hostType.getInnerType();
        if (expressions.size() > 1 && innerType.getKind() == INode.Kind.ARRAY_TYPE) {
            return ArrayWithoutInitializationExpression.oneDim(hostType, expressions.get(0), "{" + ArrayWithoutInitializationExpression.constructInnerType((ArrayType)innerType, expressions.subList(1, expressions.size())) + "}");
        }
        return ArrayWithoutInitializationExpression.getConstructorName(hostType);
    }

    @NotNull
    private static String oneDim(@NotNull Type type, @NotNull Expression size) {
        return ArrayWithoutInitializationExpression.oneDim(type, size, "");
    }

    @NotNull
    private static String oneDim(@NotNull Type type, @NotNull Expression size, @NotNull String init) {
        String commaWithInit = init.isEmpty() ? "" : ", " + init;
        return ArrayWithoutInitializationExpression.getConstructorName(type) + "(" + size.toKotlin() + commaWithInit + ")";
    }

    @NotNull
    private static String getConstructorName(@NotNull Type type) {
        return AstUtil.replaceLastQuest(type.toKotlin());
    }
}

