/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k.ast;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.INode;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.util.AstUtil;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;

public class ArrayInitializerExpression
extends Expression {
    private final Type myType;
    private final List<Expression> myInitializers;

    public ArrayInitializerExpression(Type type, List<Expression> initializers) {
        this.myType = type;
        this.myInitializers = initializers;
    }

    @NotNull
    private static String createArrayFunction(@NotNull Type type) {
        String sType = ArrayInitializerExpression.innerTypeStr(type);
        if (PRIMITIVE_TYPES.contains(sType)) {
            return sType + "Array";
        }
        return AstUtil.lowerFirstCharacter(type.convertedToNotNull().toKotlin());
    }

    @NotNull
    private static String innerTypeStr(@NotNull Type type) {
        return type.convertedToNotNull().toKotlin().replace("Array", "").toLowerCase();
    }

    @NotNull
    private static String createInitializers(@NotNull Type type, @NotNull List<Expression> initializers) {
        LinkedList<String> arguments = new LinkedList<String>();
        for (Expression i : initializers) {
            arguments.add(ArrayInitializerExpression.explicitConvertIfNeeded(type, i));
        }
        return AstUtil.join(arguments, ", ");
    }

    @NotNull
    private static String explicitConvertIfNeeded(@NotNull Type type, @NotNull Expression i) {
        String afterReplace;
        HashSet<String> doubleOrFloatTypes = new HashSet<String>(Arrays.asList("double", "float", "java.lang.double", "java.lang.float"));
        if (doubleOrFloatTypes.contains(afterReplace = ArrayInitializerExpression.innerTypeStr(type).replace(">", "").replace("<", "").replace("?", ""))) {
            if (i.getKind() == INode.Kind.LITERAL) {
                if (i.toKotlin().contains(".")) {
                    return i.toKotlin();
                }
                return i.toKotlin() + "." + "0";
            }
            return "(" + i.toKotlin() + ")" + ArrayInitializerExpression.getConversion(afterReplace);
        }
        return i.toKotlin();
    }

    @NotNull
    private static String getConversion(@NotNull String afterReplace) {
        if (afterReplace.contains("double")) {
            return "." + OperatorConventions.DOUBLE + "()";
        }
        if (afterReplace.contains("float")) {
            return "." + OperatorConventions.FLOAT + "()";
        }
        return "";
    }

    @Override
    @NotNull
    public String toKotlin() {
        return ArrayInitializerExpression.createArrayFunction(this.myType) + "(" + ArrayInitializerExpression.createInitializers(this.myType, this.myInitializers) + ")";
    }
}

