/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.core.JavaCoreEnvironment;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.j2k.Converter;
import org.jetbrains.jet.j2k.SetupJavaCoreEnvironmentException;
import org.jetbrains.jet.j2k.visitors.ClassVisitor;

public class JavaToKotlinTranslator {
    private static final Converter CONVERTER = new Converter();

    private JavaToKotlinTranslator() {
    }

    @Nullable
    private static PsiFile createFile(@NotNull String text) {
        JavaCoreEnvironment javaCoreEnvironment = JavaToKotlinTranslator.setUpJavaCoreEnvironment();
        return PsiFileFactory.getInstance(javaCoreEnvironment.getProject()).createFileFromText("test.java", JavaLanguage.INSTANCE, (CharSequence)text);
    }

    @NotNull
    static JavaCoreEnvironment setUpJavaCoreEnvironment() {
        JavaCoreEnvironment javaCoreEnvironment = new JavaCoreEnvironment(new Disposable(){

            @Override
            public void dispose() {
            }
        });
        javaCoreEnvironment.addToClasspath(JavaToKotlinTranslator.findRtJar());
        File annotations = JavaToKotlinTranslator.findAnnotations();
        if (annotations != null && annotations.exists()) {
            javaCoreEnvironment.addToClasspath(annotations);
        }
        return javaCoreEnvironment;
    }

    @NotNull
    static String prettify(@Nullable String code) {
        if (code == null) {
            return "";
        }
        return code.trim().replaceAll("\r\n", "\n").replaceAll(" \n", "\n").replaceAll("\n ", "\n").replaceAll("\n+", "\n").replaceAll(" +", " ").trim();
    }

    @Nullable
    private static File findRtJar() {
        File rtJar;
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            rtJar = JavaToKotlinTranslator.findActiveRtJar(true);
            if (rtJar == null) {
                throw new SetupJavaCoreEnvironmentException("JAVA_HOME environment variable needs to be defined");
            }
        } else {
            rtJar = JavaToKotlinTranslator.findRtJar(javaHome);
        }
        if (!(rtJar != null && rtJar.exists() || (rtJar = JavaToKotlinTranslator.findActiveRtJar(true)) != null && rtJar.exists())) {
            throw new SetupJavaCoreEnvironmentException("No rt.jar found under JAVA_HOME=" + javaHome);
        }
        return rtJar;
    }

    @Nullable
    private static File findRtJar(String javaHome) {
        File rtJar = new File(javaHome, "jre/lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        File classesJar = new File(new File(javaHome).getParentFile().getAbsolutePath(), "Classes/classes.jar");
        if (classesJar.exists()) {
            return classesJar;
        }
        return null;
    }

    @Nullable
    private static File findAnnotations() {
        for (ClassLoader classLoader = JavaToKotlinTranslator.class.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            URLClassLoader loader = (URLClassLoader)classLoader;
            for (URL url : loader.getURLs()) {
                if (!"file".equals(url.getProtocol()) || !url.getFile().endsWith("/annotations.jar")) continue;
                return new File(url.getFile());
            }
        }
        return null;
    }

    @Nullable
    private static File findActiveRtJar(boolean failOnError) {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader instanceof URLClassLoader) {
            URLClassLoader loader = (URLClassLoader)systemClassLoader;
            for (URL url : loader.getURLs()) {
                if (!"file".equals(url.getProtocol())) continue;
                if (url.getFile().endsWith("/lib/rt.jar")) {
                    return new File(url.getFile());
                }
                if (!url.getFile().endsWith("/Classes/classes.jar")) continue;
                return new File(url.getFile()).getAbsoluteFile();
            }
            if (failOnError) {
                throw new SetupJavaCoreEnvironmentException("Could not find rt.jar in system class loader: " + StringUtil.join(loader.getURLs(), new Function<URL, String>(){

                    @Override
                    @NotNull
                    public String fun(@NotNull URL url) {
                        return url.toString() + "\n";
                    }
                }, ", "));
            }
        } else if (failOnError) {
            throw new SetupJavaCoreEnvironmentException("System class loader is not an URLClassLoader: " + systemClassLoader);
        }
        return null;
    }

    static void setClassIdentifiers(@NotNull Converter converter, @NotNull PsiElement psiFile) {
        ClassVisitor c = new ClassVisitor();
        psiFile.accept(c);
        converter.clearClassIdentifiers();
        converter.setClassIdentifiers(c.getClassIdentifiers());
    }

    @NotNull
    static String generateKotlinCode(@NotNull String javaCode) {
        PsiFile file = JavaToKotlinTranslator.createFile(javaCode);
        if (file != null && file instanceof PsiJavaFile) {
            JavaToKotlinTranslator.setClassIdentifiers(CONVERTER, file);
            return JavaToKotlinTranslator.prettify(CONVERTER.fileToFile((PsiJavaFile)file).toKotlin());
        }
        return "";
    }

    public static void main(@NotNull String[] args) throws IOException {
        PrintStream out = System.out;
        if (args.length == 1) {
            String kotlinCode = "";
            try {
                kotlinCode = JavaToKotlinTranslator.generateKotlinCode(args[0]);
            }
            catch (Exception e) {
                out.println("EXCEPTION: " + e.getMessage());
            }
            if (kotlinCode.isEmpty()) {
                out.println("EXCEPTION: generated code is empty.");
            } else {
                out.println(kotlinCode);
            }
        } else {
            out.println("EXCEPTION: wrong number of arguments (should be 1).");
        }
    }

    public static String translateToKotlin(String code) {
        return JavaToKotlinTranslator.generateKotlinCode(code);
    }
}

