/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.psi.JavaRecursiveElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.j2k.Converter;

public class ConverterUtil {
    private ConverterUtil() {
    }

    @NotNull
    public static String createMainFunction(@NotNull PsiFile file) {
        LinkedList<Pair<String, PsiMethod>> classNamesWithMains = new LinkedList<Pair<String, PsiMethod>>();
        for (PsiClass c : ((PsiJavaFile)file).getClasses()) {
            PsiMethod main = ConverterUtil.findMainMethod(c);
            if (main == null) continue;
            classNamesWithMains.add(new Pair<String, PsiMethod>(c.getName(), main));
        }
        if (classNamesWithMains.size() > 0) {
            String className = (String)((Pair)classNamesWithMains.get(0)).getFirst();
            return MessageFormat.format("fun main(args : Array<String?>?) = {0}.main(args)", className);
        }
        return "";
    }

    @Nullable
    private static PsiMethod findMainMethod(@NotNull PsiClass aClass) {
        if (ConverterUtil.isMainClass(aClass)) {
            PsiMethod[] mainMethods = aClass.findMethodsByName("main", false);
            return ConverterUtil.findMainMethod(mainMethods);
        }
        return null;
    }

    @Nullable
    private static PsiMethod findMainMethod(@NotNull PsiMethod[] mainMethods) {
        for (PsiMethod mainMethod : mainMethods) {
            if (!ConverterUtil.isMainMethod(mainMethod)) continue;
            return mainMethod;
        }
        return null;
    }

    private static boolean isMainClass(@NotNull PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (psiClass.isInterface()) {
            return false;
        }
        return psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static");
    }

    public static boolean isMainMethod(@Nullable PsiMethod method) {
        if (method == null || method.getContainingClass() == null) {
            return false;
        }
        if (PsiType.VOID != method.getReturnType()) {
            return false;
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        PsiType type = parameters[0].getType();
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        return componentType.equalsToText("java.lang.String");
    }

    public static int countWritingAccesses(@Nullable PsiElement element, @Nullable PsiElement container) {
        int counter = 0;
        if (container != null) {
            ReferenceCollector visitor = new ReferenceCollector();
            container.accept(visitor);
            for (PsiReferenceExpression e : visitor.getCollectedReferences()) {
                if (!e.isReferenceTo(element) || !PsiUtil.isAccessedForWriting(e)) continue;
                ++counter;
            }
        }
        return counter;
    }

    static boolean isReadOnly(PsiElement element, PsiElement container) {
        return ConverterUtil.countWritingAccesses(element, container) == 0;
    }

    public static boolean isAnnotatedAsNotNull(@Nullable PsiModifierList modifierList) {
        if (modifierList != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation a : annotations = modifierList.getAnnotations()) {
                String qualifiedName = a.getQualifiedName();
                if (qualifiedName == null || !Converter.NOT_NULL_ANNOTATIONS.contains(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    static class ReferenceCollector
    extends JavaRecursiveElementVisitor {
        private List<PsiReferenceExpression> myCollectedReferences = new LinkedList<PsiReferenceExpression>();

        ReferenceCollector() {
        }

        public List<PsiReferenceExpression> getCollectedReferences() {
            return this.myCollectedReferences;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            this.myCollectedReferences.add(expression);
        }
    }
}

