/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.j2k;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.ImmutableSet;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMember;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.j2k.ConverterUtil;
import org.jetbrains.jet.j2k.J2KConverterFlags;
import org.jetbrains.jet.j2k.ast.AnonymousClass;
import org.jetbrains.jet.j2k.ast.AssignmentExpression;
import org.jetbrains.jet.j2k.ast.Block;
import org.jetbrains.jet.j2k.ast.CallChainExpression;
import org.jetbrains.jet.j2k.ast.Class;
import org.jetbrains.jet.j2k.ast.ClassType;
import org.jetbrains.jet.j2k.ast.Constructor;
import org.jetbrains.jet.j2k.ast.DummyStringExpression;
import org.jetbrains.jet.j2k.ast.Element;
import org.jetbrains.jet.j2k.ast.Enum;
import org.jetbrains.jet.j2k.ast.EnumConstant;
import org.jetbrains.jet.j2k.ast.Expression;
import org.jetbrains.jet.j2k.ast.Field;
import org.jetbrains.jet.j2k.ast.File;
import org.jetbrains.jet.j2k.ast.Function;
import org.jetbrains.jet.j2k.ast.INode;
import org.jetbrains.jet.j2k.ast.Identifier;
import org.jetbrains.jet.j2k.ast.IdentifierImpl;
import org.jetbrains.jet.j2k.ast.Import;
import org.jetbrains.jet.j2k.ast.Initializer;
import org.jetbrains.jet.j2k.ast.Member;
import org.jetbrains.jet.j2k.ast.Node;
import org.jetbrains.jet.j2k.ast.Parameter;
import org.jetbrains.jet.j2k.ast.ParameterList;
import org.jetbrains.jet.j2k.ast.Statement;
import org.jetbrains.jet.j2k.ast.SureCallChainExpression;
import org.jetbrains.jet.j2k.ast.Trait;
import org.jetbrains.jet.j2k.ast.Type;
import org.jetbrains.jet.j2k.util.AstUtil;
import org.jetbrains.jet.j2k.visitors.Dispatcher;
import org.jetbrains.jet.j2k.visitors.ElementVisitor;
import org.jetbrains.jet.j2k.visitors.ExpressionVisitor;
import org.jetbrains.jet.j2k.visitors.ExpressionVisitorForDirectObjectInheritors;
import org.jetbrains.jet.j2k.visitors.StatementVisitor;
import org.jetbrains.jet.j2k.visitors.SuperVisitor;
import org.jetbrains.jet.j2k.visitors.ThisVisitor;
import org.jetbrains.jet.j2k.visitors.TypeVisitor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;

public class Converter {
    @NotNull
    public static final Set<String> NOT_NULL_ANNOTATIONS = ImmutableSet.of("org.jetbrains.annotations.NotNull", "com.sun.istack.internal.NotNull", "javax.annotation.Nonnull");
    @NotNull
    private Set<String> classIdentifiers = Sets.newHashSet();
    @NotNull
    private final Dispatcher dispatcher = new Dispatcher(this);
    @Nullable
    private PsiType methodReturnType = null;
    @NotNull
    private final Set<J2KConverterFlags> flags = Sets.newHashSet();

    public boolean addFlag(@NotNull J2KConverterFlags flag) {
        return this.flags.add(flag);
    }

    public boolean hasFlag(@NotNull J2KConverterFlags flag) {
        return this.flags.contains((Object)flag);
    }

    public void setClassIdentifiers(@NotNull Set<String> identifiers) {
        this.classIdentifiers = identifiers;
    }

    @NotNull
    public Set<String> getClassIdentifiers() {
        return Collections.unmodifiableSet(this.classIdentifiers);
    }

    @Nullable
    public PsiType getMethodReturnType() {
        return this.methodReturnType;
    }

    public void clearClassIdentifiers() {
        this.classIdentifiers.clear();
    }

    @NotNull
    public String elementToKotlin(@NotNull PsiElement element) {
        if (element instanceof PsiJavaFile) {
            return this.fileToFile((PsiJavaFile)element).toKotlin();
        }
        if (element instanceof PsiClass) {
            return this.classToClass((PsiClass)element).toKotlin();
        }
        if (element instanceof PsiMethod) {
            return this.methodToFunction((PsiMethod)element).toKotlin();
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            return this.fieldToField(field, field.getContainingClass()).toKotlin();
        }
        if (element instanceof PsiStatement) {
            return this.statementToStatement((PsiStatement)element).toKotlin();
        }
        if (element instanceof PsiExpression) {
            return this.expressionToExpression((PsiExpression)element).toKotlin();
        }
        return "";
    }

    @NotNull
    public File fileToFile(@NotNull PsiJavaFile javaFile) {
        return this.fileToFile(javaFile, Collections.<String>emptyList());
    }

    @NotNull
    public File fileToFileWithCompatibilityImport(@NotNull PsiJavaFile javaFile) {
        return this.fileToFile(javaFile, Collections.singletonList("kotlin.compatibility.*"));
    }

    @NotNull
    private File fileToFile(PsiJavaFile javaFile, List<String> additionalImports) {
        PsiImportList importList = javaFile.getImportList();
        List<Import> imports = importList == null ? Collections.emptyList() : Converter.importsToImportList(importList.getAllImportStatements());
        for (String i : additionalImports) {
            imports.add(new Import(i));
        }
        return new File(Converter.quoteKeywords(javaFile.getPackageName()), imports, this.classesToClassList(javaFile.getClasses()), ConverterUtil.createMainFunction(javaFile));
    }

    @NotNull
    private static String quoteKeywords(@NotNull String packageName) {
        LinkedList<String> result = new LinkedList<String>();
        for (String part : packageName.split("\\.")) {
            result.add(new IdentifierImpl(part).toKotlin());
        }
        return AstUtil.join(result, ".");
    }

    @NotNull
    private List<Class> classesToClassList(@NotNull PsiClass[] classes) {
        LinkedList<Class> result = new LinkedList<Class>();
        for (PsiClass t : classes) {
            result.add(this.classToClass(t));
        }
        return result;
    }

    @NotNull
    public AnonymousClass anonymousClassToAnonymousClass(@NotNull PsiAnonymousClass anonymousClass) {
        return new AnonymousClass(this, this.getMembers(anonymousClass));
    }

    @NotNull
    private List<Member> getMembers(@NotNull PsiClass psiClass) {
        LinkedList<Member> members = new LinkedList<Member>();
        for (PsiElement e : psiClass.getChildren()) {
            if (e instanceof PsiMethod) {
                members.add(this.methodToFunction((PsiMethod)e, true));
                continue;
            }
            if (e instanceof PsiField) {
                members.add(this.fieldToField((PsiField)e, psiClass));
                continue;
            }
            if (e instanceof PsiClass) {
                members.add(this.classToClass((PsiClass)e));
                continue;
            }
            if (e instanceof PsiClassInitializer) {
                members.add(this.initializerToInitializer((PsiClassInitializer)e));
                continue;
            }
            if (!(e instanceof PsiMember)) continue;
            System.out.println(e.getClass() + " " + e.getText());
        }
        return members;
    }

    @NotNull
    private static List<Field> getFinalOrWithEmptyInitializer(@NotNull List<? extends Field> fields) {
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field field : fields) {
            if (!field.isVal() && !field.getInitializer().toKotlin().isEmpty()) continue;
            result.add(field);
        }
        return result;
    }

    @NotNull
    private static List<Parameter> createParametersFromFields(@NotNull List<? extends Field> fields) {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        for (Field field : fields) {
            result.add(new Parameter(new IdentifierImpl("_" + field.getIdentifier().getName()), field.getType()));
        }
        return result;
    }

    @NotNull
    private static List<Statement> createInitStatementsFromFields(@NotNull List<? extends Field> fields) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (Field field : fields) {
            String identifierToKotlin = field.getIdentifier().toKotlin();
            result.add(new DummyStringExpression(identifierToKotlin + " = " + "_" + identifierToKotlin));
        }
        return result;
    }

    @NotNull
    private static String createPrimaryConstructorInvocation(@NotNull String s, @NotNull List<? extends Field> fields, @NotNull Map<String, String> initializers) {
        LinkedList<String> result = new LinkedList<String>();
        for (Field field : fields) {
            String id = field.getIdentifier().toKotlin();
            result.add(initializers.get(id));
        }
        return s + "(" + AstUtil.join(result, ", ") + ")";
    }

    @NotNull
    private Class classToClass(@NotNull PsiClass psiClass) {
        Set<String> modifiers = Converter.modifiersListToModifiersSet(psiClass.getModifierList());
        List<Field> fields = this.fieldsToFieldList(psiClass.getFields(), psiClass);
        List<Element> typeParameters = this.elementsToElementList(psiClass.getTypeParameters());
        List<Type> implementsTypes = this.typesToNotNullableTypeList(psiClass.getImplementsListTypes());
        List<Type> extendsTypes = this.typesToNotNullableTypeList(psiClass.getExtendsListTypes());
        IdentifierImpl name = new IdentifierImpl(psiClass.getName());
        LinkedList<Expression> baseClassParams = new LinkedList<Expression>();
        List<Member> members = this.getMembers(psiClass);
        SuperVisitor visitor = new SuperVisitor();
        psiClass.accept(visitor);
        HashSet<PsiExpressionList> resolvedSuperCallParameters = visitor.getResolvedSuperCallParameters();
        if (resolvedSuperCallParameters.size() == 1) {
            baseClassParams.addAll(this.expressionsToExpressionList(resolvedSuperCallParameters.toArray(new PsiExpressionList[1])[0].getExpressions()));
        }
        if (!psiClass.isEnum() && !psiClass.isInterface() && psiClass.getConstructors().length > 1 && Converter.getPrimaryConstructorForThisCase(psiClass) == null) {
            List<Field> finalOrWithEmptyInitializer = Converter.getFinalOrWithEmptyInitializer(fields);
            HashMap<String, String> initializers = new HashMap<String, String>();
            for (Member m : members) {
                Function f;
                if (m.getKind() != INode.Kind.CONSTRUCTOR || ((Constructor)(f = (Function)m)).isPrimary()) continue;
                for (Field fo : finalOrWithEmptyInitializer) {
                    String init = Converter.getDefaultInitializer(fo);
                    initializers.put(fo.getIdentifier().toKotlin(), init);
                }
                LinkedList<Statement> newStatements = new LinkedList<Statement>();
                for (Statement s : f.getBlock().getStatements()) {
                    AssignmentExpression assignmentExpression;
                    boolean isRemoved = false;
                    if (s.getKind() == INode.Kind.ASSIGNMENT_EXPRESSION && (assignmentExpression = (AssignmentExpression)s).getLeft().getKind() == INode.Kind.CALL_CHAIN) {
                        for (Field fo : finalOrWithEmptyInitializer) {
                            String id = fo.getIdentifier().toKotlin();
                            if (!((CallChainExpression)assignmentExpression.getLeft()).getIdentifier().toKotlin().endsWith("." + id)) continue;
                            initializers.put(id, assignmentExpression.getRight().toKotlin());
                            isRemoved = true;
                        }
                    }
                    if (isRemoved) continue;
                    newStatements.add(s);
                }
                newStatements.add(0, new DummyStringExpression("val __ = " + Converter.createPrimaryConstructorInvocation(name.toKotlin(), finalOrWithEmptyInitializer, initializers)));
                f.setBlock(new Block(newStatements));
            }
            members.add(new Constructor(Identifier.EMPTY_IDENTIFIER, Collections.<String>emptySet(), new ClassType(name), Collections.<Element>emptyList(), new ParameterList(Converter.createParametersFromFields(finalOrWithEmptyInitializer)), new Block(Converter.createInitStatementsFromFields(finalOrWithEmptyInitializer)), true));
        }
        if (psiClass.isInterface()) {
            return new Trait(this, name, modifiers, typeParameters, extendsTypes, Collections.<Expression>emptyList(), implementsTypes, members);
        }
        if (psiClass.isEnum()) {
            return new Enum(this, name, modifiers, typeParameters, Collections.<Type>emptyList(), Collections.<Expression>emptyList(), implementsTypes, members);
        }
        return new Class(this, name, modifiers, typeParameters, extendsTypes, baseClassParams, implementsTypes, members);
    }

    @NotNull
    private Initializer initializerToInitializer(@NotNull PsiClassInitializer i) {
        return new Initializer(this.blockToBlock(i.getBody(), true), Converter.modifiersListToModifiersSet(i.getModifierList()));
    }

    @NotNull
    public static String getDefaultInitializer(@NotNull Field f) {
        if (f.getType().isNullable()) {
            return "null";
        }
        String typeToKotlin = f.getType().toKotlin();
        if (typeToKotlin.equals("Boolean")) {
            return "false";
        }
        if (typeToKotlin.equals("Char")) {
            return "' '";
        }
        if (typeToKotlin.equals("Double")) {
            return "0." + OperatorConventions.DOUBLE + "()";
        }
        if (typeToKotlin.equals("Float")) {
            return "0." + OperatorConventions.FLOAT + "()";
        }
        return "0";
    }

    @NotNull
    private List<Field> fieldsToFieldList(@NotNull PsiField[] fields, PsiClass psiClass) {
        LinkedList<Field> result = new LinkedList<Field>();
        for (PsiField f : fields) {
            result.add(this.fieldToField(f, psiClass));
        }
        return result;
    }

    @NotNull
    private Field fieldToField(@NotNull PsiField field, PsiClass psiClass) {
        Set<String> modifiers = Converter.modifiersListToModifiersSet(field.getModifierList());
        if (field instanceof PsiEnumConstant) {
            return new EnumConstant(new IdentifierImpl(field.getName()), modifiers, this.typeToType(field.getType()), this.elementToElement(((PsiEnumConstant)field).getArgumentList()));
        }
        return new Field(new IdentifierImpl(field.getName()), modifiers, this.typeToType(field.getType()), this.createSureCallOnlyForChain(field.getInitializer(), field.getType()), ConverterUtil.countWritingAccesses(field, psiClass));
    }

    @Nullable
    private static PsiMethod getPrimaryConstructorForThisCase(@NotNull PsiClass psiClass) {
        ThisVisitor tv = new ThisVisitor();
        psiClass.accept(tv);
        return tv.getPrimaryConstructor();
    }

    public static boolean isConstructorPrimary(@NotNull PsiMethod constructor) {
        if (constructor.getParent() instanceof PsiClass) {
            PsiClass parent = (PsiClass)constructor.getParent();
            if (parent.getConstructors().length == 1) {
                return true;
            }
            PsiMethod c = Converter.getPrimaryConstructorForThisCase(parent);
            if (c != null && c.hashCode() == constructor.hashCode()) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static List<Statement> removeEmpty(@NotNull List<Statement> statements) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (Statement s : statements) {
            if (s == Statement.EMPTY_STATEMENT || s == Expression.EMPTY_EXPRESSION) continue;
            result.add(s);
        }
        return result;
    }

    @NotNull
    private Function methodToFunction(@NotNull PsiMethod method) {
        return this.methodToFunction(method, true);
    }

    @NotNull
    private Function methodToFunction(@NotNull PsiMethod method, boolean notEmpty) {
        if (Converter.isOverrideObjectDirect(method)) {
            this.dispatcher.setExpressionVisitor(new ExpressionVisitorForDirectObjectInheritors(this));
        } else {
            this.dispatcher.setExpressionVisitor(new ExpressionVisitor(this));
        }
        this.methodReturnType = method.getReturnType();
        IdentifierImpl identifier = new IdentifierImpl(method.getName());
        Type returnType = this.typeToType(method.getReturnType(), ConverterUtil.isAnnotatedAsNotNull(method.getModifierList()));
        Block body = this.hasFlag(J2KConverterFlags.SKIP_BODIES) ? Block.EMPTY_BLOCK : this.blockToBlock(method.getBody(), notEmpty);
        ParameterList params = this.createFunctionParameters(method);
        List<Element> typeParameters = this.elementsToElementList(method.getTypeParameters());
        Set<String> modifiers = Converter.modifiersListToModifiersSet(method.getModifierList());
        if (this.isOverrideAnyMethodExceptMethodsFromObject(method)) {
            modifiers.add("override");
        }
        if (method.getParent() instanceof PsiClass && ((PsiClass)method.getParent()).isInterface()) {
            modifiers.remove("abstract");
        }
        if (Converter.isNotOpenMethod(method)) {
            modifiers.add("not open");
        }
        if (method.isConstructor()) {
            boolean isPrimary = Converter.isConstructorPrimary(method);
            return new Constructor(identifier, modifiers, returnType, typeParameters, params, new Block(Converter.removeEmpty(body.getStatements()), false), isPrimary);
        }
        return new Function(identifier, modifiers, returnType, typeParameters, params, body);
    }

    @NotNull
    private ParameterList createFunctionParameters(@NotNull PsiMethod method) {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            result.add(new Parameter(new IdentifierImpl(parameter.getName()), this.typeToType(parameter.getType(), ConverterUtil.isAnnotatedAsNotNull(parameter.getModifierList())), ConverterUtil.isReadOnly(parameter, method.getBody())));
        }
        return new ParameterList(result);
    }

    private static boolean isNotOpenMethod(@NotNull PsiMethod method) {
        PsiModifierList parentModifierList;
        return method.getParent() instanceof PsiClass && ((parentModifierList = ((PsiClass)method.getParent()).getModifierList()) != null && parentModifierList.hasExplicitModifier("final") || ((PsiClass)method.getParent()).isEnum());
    }

    private boolean isOverrideAnyMethodExceptMethodsFromObject(@NotNull PsiMethod method) {
        boolean counter = Converter.normalCase(method);
        if (counter) {
            return true;
        }
        if (Converter.isInheritFromObject(method)) {
            return this.caseForObject(method);
        }
        return false;
    }

    private boolean caseForObject(@NotNull PsiMethod method) {
        PsiClass containing = method.getContainingClass();
        if (containing != null) {
            for (PsiClassType s : containing.getSuperTypes()) {
                String canonicalText = s.getCanonicalText();
                if (canonicalText.equals("java.lang.Object") || this.getClassIdentifiers().contains(canonicalText)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean normalCase(@NotNull PsiMethod method) {
        int counter = 0;
        for (HierarchicalMethodSignature s : method.getHierarchicalMethodSignature().getSuperSignatures()) {
            PsiClass containingClass = s.getMethod().getContainingClass();
            String qualifiedName = containingClass != null ? containingClass.getQualifiedName() : "";
            if (qualifiedName == null || qualifiedName.equals("java.lang.Object")) continue;
            ++counter;
        }
        return counter > 0;
    }

    private static boolean isInheritFromObject(@NotNull PsiMethod method) {
        List<HierarchicalMethodSignature> superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
        for (HierarchicalMethodSignature s : superSignatures) {
            PsiClass containingClass = s.getMethod().getContainingClass();
            String qualifiedName = containingClass != null ? containingClass.getQualifiedName() : "";
            if (qualifiedName == null || !qualifiedName.equals("java.lang.Object")) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverrideObjectDirect(@NotNull PsiMethod method) {
        List<HierarchicalMethodSignature> superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
        if (superSignatures.size() == 1) {
            String qualifiedName;
            PsiClass containingClass = superSignatures.get(0).getMethod().getContainingClass();
            String string = qualifiedName = containingClass != null ? containingClass.getQualifiedName() : "";
            if (qualifiedName != null && qualifiedName.equals("java.lang.Object")) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Block blockToBlock(@Nullable PsiCodeBlock block, boolean notEmpty) {
        if (block == null) {
            return Block.EMPTY_BLOCK;
        }
        return new Block(this.statementsToStatementList(block.getStatements()), notEmpty);
    }

    @NotNull
    public Block blockToBlock(@Nullable PsiCodeBlock block) {
        return this.blockToBlock(block, true);
    }

    @NotNull
    public List<Statement> statementsToStatementList(@NotNull PsiStatement[] statements) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (PsiStatement t : statements) {
            result.add(this.statementToStatement(t));
        }
        return result;
    }

    @NotNull
    public List<Statement> statementsToStatementList(@NotNull List<PsiStatement> statements) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (PsiStatement t : statements) {
            result.add(this.statementToStatement(t));
        }
        return result;
    }

    @NotNull
    public Statement statementToStatement(@Nullable PsiStatement s) {
        if (s == null) {
            return Statement.EMPTY_STATEMENT;
        }
        StatementVisitor statementVisitor = new StatementVisitor(this);
        s.accept(statementVisitor);
        return statementVisitor.getResult();
    }

    @NotNull
    public List<Expression> expressionsToExpressionList(@NotNull PsiExpression[] expressions) {
        LinkedList<Expression> result = new LinkedList<Expression>();
        for (PsiExpression e : expressions) {
            result.add(this.expressionToExpression(e));
        }
        return result;
    }

    @NotNull
    public Expression expressionToExpression(@Nullable PsiExpression e) {
        if (e == null) {
            return Expression.EMPTY_EXPRESSION;
        }
        ExpressionVisitor expressionVisitor = this.dispatcher.getExpressionVisitor();
        e.accept(expressionVisitor);
        return expressionVisitor.getResult();
    }

    @NotNull
    public Element elementToElement(@Nullable PsiElement e) {
        if (e == null) {
            return Element.EMPTY_ELEMENT;
        }
        ElementVisitor elementVisitor = new ElementVisitor(this);
        e.accept(elementVisitor);
        return elementVisitor.getResult();
    }

    @NotNull
    public List<Element> elementsToElementList(@NotNull PsiElement[] elements) {
        LinkedList<Element> result = new LinkedList<Element>();
        for (PsiElement e : elements) {
            result.add(this.elementToElement(e));
        }
        return result;
    }

    @NotNull
    public Type typeToType(@Nullable PsiType type) {
        if (type == null) {
            return Type.EMPTY_TYPE;
        }
        TypeVisitor typeVisitor = new TypeVisitor(this);
        type.accept(typeVisitor);
        return typeVisitor.getResult();
    }

    @NotNull
    public List<Type> typesToTypeList(@NotNull PsiType[] types) {
        LinkedList<Type> result = new LinkedList<Type>();
        for (PsiType t : types) {
            result.add(this.typeToType(t));
        }
        return result;
    }

    @NotNull
    public Type typeToType(PsiType type, boolean notNull) {
        Type result = this.typeToType(type);
        if (notNull) {
            result.convertedToNotNull();
        }
        return result;
    }

    @NotNull
    private List<Type> typesToNotNullableTypeList(@NotNull PsiType[] types) {
        LinkedList<Type> result = new LinkedList<Type>(this.typesToTypeList(types));
        for (Type p : result) {
            p.convertedToNotNull();
        }
        return result;
    }

    @NotNull
    private static List<Import> importsToImportList(@NotNull PsiImportStatementBase[] imports) {
        LinkedList<Import> result = new LinkedList<Import>();
        for (PsiImportStatementBase i : imports) {
            Import anImport = Converter.importToImport(i);
            String name = anImport.getName();
            if (name.isEmpty() || NOT_NULL_ANNOTATIONS.contains(name)) continue;
            result.add(anImport);
        }
        return result;
    }

    @NotNull
    private static Import importToImport(@NotNull PsiImportStatementBase i) {
        PsiJavaCodeReferenceElement reference = i.getImportReference();
        if (reference != null) {
            return new Import(Converter.quoteKeywords(reference.getQualifiedName()) + (i.isOnDemand() ? ".*" : ""));
        }
        return new Import("");
    }

    @NotNull
    public List<Parameter> parametersToParameterList(@NotNull PsiParameter[] parameters) {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        for (PsiParameter t : parameters) {
            result.add(this.parameterToParameter(t));
        }
        return result;
    }

    @NotNull
    public Parameter parameterToParameter(@NotNull PsiParameter parameter) {
        return new Parameter(new IdentifierImpl(parameter.getName()), this.typeToType(parameter.getType(), ConverterUtil.isAnnotatedAsNotNull(parameter.getModifierList())));
    }

    @NotNull
    public static Identifier identifierToIdentifier(@Nullable PsiIdentifier identifier) {
        if (identifier == null) {
            return Identifier.EMPTY_IDENTIFIER;
        }
        return new IdentifierImpl(identifier.getText());
    }

    @NotNull
    public static Set<String> modifiersListToModifiersSet(@Nullable PsiModifierList modifierList) {
        HashSet<String> modifiersSet = new HashSet<String>();
        if (modifierList != null) {
            if (modifierList.hasExplicitModifier("abstract")) {
                modifiersSet.add("abstract");
            }
            if (modifierList.hasModifierProperty("final")) {
                modifiersSet.add("final");
            }
            if (modifierList.hasModifierProperty("static")) {
                modifiersSet.add("static");
            }
            if (modifierList.hasExplicitModifier("public")) {
                modifiersSet.add("public");
            }
            if (modifierList.hasExplicitModifier("protected")) {
                modifiersSet.add("protected");
            }
            if (modifierList.hasExplicitModifier("packageLocal")) {
                modifiersSet.add("internal");
            }
            if (modifierList.hasExplicitModifier("private")) {
                modifiersSet.add("private");
            }
        }
        return modifiersSet;
    }

    @NotNull
    public List<String> createConversions(@NotNull PsiCallExpression expression) {
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList != null ? argumentList.getExpressions() : new PsiExpression[]{};
        LinkedList<String> conversions = new LinkedList<String>();
        for (PsiExpression a : arguments) {
            conversions.add("");
        }
        PsiMethod resolve = expression.resolveMethod();
        if (resolve != null) {
            LinkedList<PsiType> expectedTypes = new LinkedList<PsiType>();
            LinkedList<PsiType> actualTypes = new LinkedList<PsiType>();
            for (PsiParameter psiParameter : resolve.getParameterList().getParameters()) {
                expectedTypes.add(psiParameter.getType());
            }
            for (PsiElement psiElement : arguments) {
                actualTypes.add(psiElement.getType());
            }
            if (conversions.size() == actualTypes.size() && actualTypes.size() == expectedTypes.size()) {
                for (int i = 0; i < actualTypes.size(); ++i) {
                    conversions.set(i, this.createConversionForExpression(arguments[i], (PsiType)expectedTypes.get(i)));
                }
            }
        }
        return conversions;
    }

    @NotNull
    public List<String> createConversions(@NotNull PsiPolyadicExpression expression, PsiType expectedType) {
        PsiExpression[] arguments = expression.getOperands();
        int length = arguments.length;
        LinkedList<String> conversions = new LinkedList<String>();
        List<PsiType> expectedTypes = Collections.nCopies(length, expectedType);
        LinkedList<PsiType> actualTypes = new LinkedList<PsiType>();
        for (PsiExpression e : arguments) {
            actualTypes.add(e.getType());
        }
        assert (actualTypes.size() == expectedTypes.size()) : "The type list must have the same length";
        for (int i = 0; i < actualTypes.size(); ++i) {
            conversions.add(i, this.createConversionForExpression(arguments[i], expectedTypes.get(i)));
        }
        return conversions;
    }

    @NotNull
    private String createConversionForExpression(@Nullable PsiExpression expression, @NotNull PsiType expectedType) {
        String conversion = "";
        if (expression != null) {
            PsiType actualType = expression.getType();
            boolean isPrimitiveTypeOrNull = actualType == null || Node.PRIMITIVE_TYPES.contains(actualType.getCanonicalText());
            boolean isRef = expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).isQualified() || expression instanceof PsiMethodCallExpression;
            boolean containsQuestDot = this.expressionToExpression(expression).toKotlin().contains("?.");
            if (isPrimitiveTypeOrNull && isRef && containsQuestDot) {
                conversion = conversion + ".sure()";
            }
            if (actualType != null && Converter.isConversionNeeded(actualType, expectedType)) {
                conversion = conversion + Converter.getPrimitiveTypeConversion(expectedType.getCanonicalText());
            }
        }
        return conversion;
    }

    private static boolean isConversionNeeded(@Nullable PsiType actual, @Nullable PsiType expected) {
        if (actual == null || expected == null) {
            return false;
        }
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("java.lang.Byte", "byte");
        typeMap.put("java.lang.Short", "short");
        typeMap.put("java.lang.Integer", "int");
        typeMap.put("java.lang.Long", "long");
        typeMap.put("java.lang.Float", "float");
        typeMap.put("java.lang.Double", "double");
        typeMap.put("java.lang.Character", "char");
        String expectedStr = expected.getCanonicalText();
        String actualStr = actual.getCanonicalText();
        boolean o1 = AstUtil.getOrElse(typeMap, actualStr, "").equals(expectedStr);
        boolean o2 = AstUtil.getOrElse(typeMap, expectedStr, "").equals(actualStr);
        return !actualStr.equals(expectedStr) && !(o1 ^ o2);
    }

    @NotNull
    private static String getPrimitiveTypeConversion(@NotNull String type) {
        HashMap<String, Name> conversions = new HashMap<String, Name>();
        conversions.put("byte", OperatorConventions.BYTE);
        conversions.put("short", OperatorConventions.SHORT);
        conversions.put("int", OperatorConventions.INT);
        conversions.put("long", OperatorConventions.LONG);
        conversions.put("float", OperatorConventions.FLOAT);
        conversions.put("double", OperatorConventions.DOUBLE);
        conversions.put("char", OperatorConventions.CHAR);
        conversions.put("java.lang.Byte", OperatorConventions.BYTE);
        conversions.put("java.lang.Short", OperatorConventions.SHORT);
        conversions.put("java.lang.Integer", OperatorConventions.INT);
        conversions.put("java.lang.Long", OperatorConventions.LONG);
        conversions.put("java.lang.Float", OperatorConventions.FLOAT);
        conversions.put("java.lang.Double", OperatorConventions.DOUBLE);
        conversions.put("java.lang.Character", OperatorConventions.CHAR);
        if (conversions.containsKey(type)) {
            return "." + conversions.get(type) + "()";
        }
        return "";
    }

    @NotNull
    public SureCallChainExpression createSureCallOnlyForChain(@Nullable PsiExpression expression, @NotNull PsiType type) {
        String conversion = expression != null && (expression instanceof PsiReferenceExpression || expression instanceof PsiMethodCallExpression) ? this.createConversionForExpression(expression, type) : "";
        return new SureCallChainExpression(this.expressionToExpression(expression), conversion);
    }
}

