/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.monitors;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jetbrains.jet.internal.org.picocontainer.ComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.monitors.AbstractComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.monitors.DefaultComponentMonitor;

public class WriterComponentMonitor
extends AbstractComponentMonitor {
    private PrintWriter out;
    private final ComponentMonitor delegate;

    public WriterComponentMonitor(Writer out) {
        this.out = new PrintWriter(out);
        this.delegate = new DefaultComponentMonitor();
    }

    public WriterComponentMonitor(Writer out, ComponentMonitor delegate) {
        this.out = new PrintWriter(out);
        this.delegate = delegate;
    }

    @Override
    public void instantiating(Constructor constructor) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiating {0}", new Object[]{constructor}));
        this.delegate.instantiating(constructor);
    }

    @Override
    public void instantiated(Constructor constructor, long duration) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiated {0} [{1} ms]", new Object[]{constructor, new Long(duration)}));
        this.delegate.instantiated(constructor, duration);
    }

    @Override
    public void instantiationFailed(Constructor constructor, Exception cause) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiation failed: {0}, reason: {1}", new Object[]{constructor, cause.getMessage()}));
        this.delegate.instantiationFailed(constructor, cause);
    }

    @Override
    public void invoking(Method method, Object instance) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invoking {0} on {1}", new Object[]{method, instance}));
        this.delegate.invoking(method, instance);
    }

    @Override
    public void invoked(Method method, Object instance, long duration) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invoked {0} on {1} [{2} ms]", new Object[]{method, instance, new Long(duration)}));
        this.delegate.invoked(method, instance, duration);
    }

    @Override
    public void invocationFailed(Method method, Object instance, Exception cause) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invocation failed: {0} on {1}, reason: {2}", new Object[]{method, instance, cause.getMessage()}));
        this.delegate.invocationFailed(method, instance, cause);
    }

    @Override
    public void lifecycleInvocationFailed(Method method, Object instance, RuntimeException cause) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", new Object[]{method, instance, cause.getMessage()}));
        this.delegate.lifecycleInvocationFailed(method, instance, cause);
    }
}

