/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.Parameter;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoVerificationException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVisitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.TraversalCheckingVisitor;

public class VerifyingVisitor
extends TraversalCheckingVisitor {
    private final List nestedVerificationExceptions = new ArrayList();
    private final Set verifiedComponentAdapters = new HashSet();
    private final PicoVisitor componentAdapterCollector = new ComponentAdapterCollector();
    private PicoContainer currentPico;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object traverse(Object node) throws PicoVerificationException {
        this.nestedVerificationExceptions.clear();
        this.verifiedComponentAdapters.clear();
        try {
            super.traverse(node);
            if (!this.nestedVerificationExceptions.isEmpty()) {
                throw new PicoVerificationException(new ArrayList(this.nestedVerificationExceptions));
            }
        }
        finally {
            this.nestedVerificationExceptions.clear();
            this.verifiedComponentAdapters.clear();
        }
        return Void.TYPE;
    }

    @Override
    public void visitContainer(PicoContainer pico) {
        super.visitContainer(pico);
        this.currentPico = pico;
    }

    @Override
    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
        super.visitComponentAdapter(componentAdapter);
        if (!this.verifiedComponentAdapters.contains(componentAdapter)) {
            try {
                componentAdapter.verify(this.currentPico);
            }
            catch (RuntimeException e) {
                this.nestedVerificationExceptions.add(e);
            }
            componentAdapter.accept(this.componentAdapterCollector);
        }
    }

    private class ComponentAdapterCollector
    implements PicoVisitor {
        private ComponentAdapterCollector() {
        }

        @Override
        public Object traverse(Object node) {
            return null;
        }

        @Override
        public void visitContainer(PicoContainer pico) {
        }

        @Override
        public void visitComponentAdapter(ComponentAdapter componentAdapter) {
            VerifyingVisitor.this.verifiedComponentAdapters.add(componentAdapter);
        }

        @Override
        public void visitParameter(Parameter parameter) {
        }
    }
}

