/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.TraversalCheckingVisitor;

public class MethodCallingVisitor
extends TraversalCheckingVisitor
implements Serializable {
    private transient Method method;
    private final Object[] arguments;
    private final Class type;
    private final boolean visitInInstantiationOrder;
    private final List componentInstances;

    public MethodCallingVisitor(Method method, Class ofType, Object[] arguments, boolean visitInInstantiationOrder) {
        if (method == null) {
            throw new NullPointerException();
        }
        this.method = method;
        this.arguments = arguments;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
        this.componentInstances = new ArrayList();
    }

    public MethodCallingVisitor(Method method, Class ofType, Object[] arguments) {
        this(method, ofType, arguments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object traverse(Object node) {
        this.componentInstances.clear();
        try {
            super.traverse(node);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            Iterator iterator = this.componentInstances.iterator();
            while (iterator.hasNext()) {
                this.invoke(iterator.next());
            }
        }
        finally {
            this.componentInstances.clear();
        }
        return Void.TYPE;
    }

    @Override
    public void visitContainer(PicoContainer pico) {
        super.visitContainer(pico);
        this.componentInstances.addAll(pico.getComponentInstancesOfType(this.type));
    }

    protected Method getMethod() {
        return this.method;
    }

    protected Object[] getArguments() {
        return this.arguments;
    }

    protected void invoke(Object[] targets) {
        for (int i = 0; i < targets.length; ++i) {
            this.invoke(targets[i]);
        }
    }

    protected Object invoke(Object target) {
        Method method = this.getMethod();
        try {
            method.invoke(target, this.getArguments());
        }
        catch (IllegalArgumentException e) {
            throw new PicoIntrospectionException(new StringBuffer().append("Can't call ").append(method.getName()).append(" on ").append(target).toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new PicoIntrospectionException(new StringBuffer().append("Can't call ").append(method.getName()).append(" on ").append(target).toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new PicoIntrospectionException(new StringBuffer().append("Failed when calling ").append(method.getName()).append(" on ").append(target).toString(), e.getTargetException());
        }
        return Void.TYPE;
    }
}

