/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.jet.internal.org.picocontainer.ComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.Parameter;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVisitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AbstractComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ComponentParameter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DelegatingComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.LifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ThreadLocalCyclicDependencyGuard;
import org.jetbrains.jet.internal.org.picocontainer.defaults.UnsatisfiableDependenciesException;

public abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter
implements LifecycleStrategy {
    protected transient Guard verifyingGuard;
    protected transient Parameter[] parameters;
    protected boolean allowNonPublicClasses;
    protected LifecycleStrategy lifecycleStrategy;

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy) {
        super(componentKey, componentImplementation, monitor);
        this.checkConcrete();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] != null) continue;
                throw new NullPointerException(new StringBuffer().append("Parameter ").append(i).append(" is null").toString());
            }
        }
        this.parameters = parameters;
        this.allowNonPublicClasses = allowNonPublicClasses;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses, ComponentMonitor monitor) {
        this(componentKey, componentImplementation, parameters, allowNonPublicClasses, monitor, new DefaultLifecycleStrategy(monitor));
    }

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) {
        this(componentKey, componentImplementation, parameters, allowNonPublicClasses, new DelegatingComponentMonitor());
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (this.getComponentImplementation().getModifiers() & 0x400) == 1024;
        if (this.getComponentImplementation().isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(this.getComponentImplementation());
        }
    }

    protected Parameter[] createDefaultParameters(Class[] parameters) {
        Parameter[] componentParameters = new Parameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            componentParameters[i] = ComponentParameter.DEFAULT;
        }
        return componentParameters;
    }

    @Override
    public void verify(final PicoContainer container) throws PicoIntrospectionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new Guard(){

                @Override
                public Object run() {
                    Constructor constructor = InstantiatingComponentAdapter.this.getGreediestSatisfiableConstructor(this.guardedContainer);
                    Class[] parameterTypes = constructor.getParameterTypes();
                    Parameter[] currentParameters = InstantiatingComponentAdapter.this.parameters != null ? InstantiatingComponentAdapter.this.parameters : InstantiatingComponentAdapter.this.createDefaultParameters(parameterTypes);
                    for (int i = 0; i < currentParameters.length; ++i) {
                        currentParameters[i].verify(container, InstantiatingComponentAdapter.this, parameterTypes[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setArguments(container);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    @Override
    public void accept(PicoVisitor visitor) {
        super.accept(visitor);
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i].accept(visitor);
            }
        }
    }

    @Override
    public void start(Object component) {
        this.lifecycleStrategy.start(component);
    }

    @Override
    public void stop(Object component) {
        this.lifecycleStrategy.stop(component);
    }

    @Override
    public void dispose(Object component) {
        this.lifecycleStrategy.dispose(component);
    }

    @Override
    public boolean hasLifecycle(Class type) {
        return this.lifecycleStrategy.hasLifecycle(type);
    }

    protected Object newInstance(Constructor constructor, Object[] parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(parameters);
    }

    protected abstract Constructor getGreediestSatisfiableConstructor(PicoContainer var1) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException;

    protected static abstract class Guard
    extends ThreadLocalCyclicDependencyGuard {
        protected PicoContainer guardedContainer;

        protected Guard() {
        }

        protected void setArguments(PicoContainer container) {
            this.guardedContainer = container;
        }
    }
}

