/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import org.jetbrains.jet.internal.org.picocontainer.LifecycleManager;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AbstractComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.LifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.monitors.DefaultComponentMonitor;

public class InstanceComponentAdapter
extends AbstractComponentAdapter
implements LifecycleManager,
LifecycleStrategy {
    private Object componentInstance;
    private LifecycleStrategy lifecycleStrategy;

    public InstanceComponentAdapter(Object componentKey, Object componentInstance) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentInstance, new DefaultLifecycleStrategy(new DefaultComponentMonitor()));
    }

    public InstanceComponentAdapter(Object componentKey, Object componentInstance, LifecycleStrategy lifecycleStrategy) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, InstanceComponentAdapter.getInstanceClass(componentInstance));
        this.componentInstance = componentInstance;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    private static Class getInstanceClass(Object componentInstance) {
        if (componentInstance == null) {
            throw new NullPointerException("componentInstance cannot be null");
        }
        return componentInstance.getClass();
    }

    @Override
    public Object getComponentInstance(PicoContainer container) {
        return this.componentInstance;
    }

    @Override
    public void verify(PicoContainer container) {
    }

    @Override
    public void start(PicoContainer container) {
        this.start(this.componentInstance);
    }

    @Override
    public void stop(PicoContainer container) {
        this.stop(this.componentInstance);
    }

    @Override
    public void dispose(PicoContainer container) {
        this.dispose(this.componentInstance);
    }

    @Override
    public boolean hasLifecycle() {
        return this.hasLifecycle(this.componentInstance.getClass());
    }

    @Override
    public void start(Object component) {
        this.lifecycleStrategy.start(this.componentInstance);
    }

    @Override
    public void stop(Object component) {
        this.lifecycleStrategy.stop(this.componentInstance);
    }

    @Override
    public void dispose(Object component) {
        this.lifecycleStrategy.dispose(this.componentInstance);
    }

    @Override
    public boolean hasLifecycle(Class type) {
        return this.lifecycleStrategy.hasLifecycle(type);
    }
}

