/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.ComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoInitializationException;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DecoratingComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.NotConcreteRegistrationException;

public class ImplementationHidingComponentAdapter
extends DecoratingComponentAdapter {
    private final boolean strict;

    public ImplementationHidingComponentAdapter(ComponentAdapter delegate, boolean strict) {
        super(delegate);
        this.strict = strict;
    }

    @Override
    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentKey = this.getDelegate().getComponentKey();
        Class[] classes = null;
        if (componentKey instanceof Class && ((Class)this.getDelegate().getComponentKey()).isInterface()) {
            classes = new Class[]{(Class)this.getDelegate().getComponentKey()};
        } else if (componentKey instanceof Class[]) {
            classes = (Class[])componentKey;
        } else {
            if (this.strict) {
                throw new PicoIntrospectionException(new StringBuffer().append("In strict mode, ").append(this.getClass().getName()).append(" only allows components registered with interface keys (java.lang.Class or java.lang.Class[])").toString());
            }
            return this.getDelegate().getComponentInstance(container);
        }
        Class[] interfaces = this.verifyInterfacesOnly(classes);
        return this.createProxy(interfaces, container, this.getDelegate().getComponentImplementation().getClassLoader());
    }

    private Object createProxy(Class[] interfaces, final PicoContainer container, ClassLoader classLoader) {
        return Proxy.newProxyInstance(classLoader, interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object componentInstance = ImplementationHidingComponentAdapter.this.getDelegate().getComponentInstance(container);
                ComponentMonitor componentMonitor = ImplementationHidingComponentAdapter.this.currentMonitor();
                try {
                    componentMonitor.invoking(method, componentInstance);
                    long startTime = System.currentTimeMillis();
                    Object object = method.invoke(componentInstance, args);
                    componentMonitor.invoked(method, componentInstance, System.currentTimeMillis() - startTime);
                    return object;
                }
                catch (InvocationTargetException ite) {
                    componentMonitor.invocationFailed(method, componentInstance, ite);
                    throw ite.getTargetException();
                }
            }
        });
    }

    private Class[] verifyInterfacesOnly(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].isInterface()) continue;
            throw new PicoIntrospectionException(new StringBuffer().append("Class keys must be interfaces. ").append(classes[i]).append(" is not an interface.").toString());
        }
        return classes;
    }
}

