/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jetbrains.jet.internal.org.picocontainer.ComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ComponentMonitorStrategy;
import org.jetbrains.jet.internal.org.picocontainer.monitors.DefaultComponentMonitor;

public class DelegatingComponentMonitor
implements Serializable,
ComponentMonitor,
ComponentMonitorStrategy {
    private ComponentMonitor delegate;

    public DelegatingComponentMonitor(ComponentMonitor delegate) {
        this.checkMonitor(delegate);
        this.delegate = delegate;
    }

    public DelegatingComponentMonitor() {
        this(DefaultComponentMonitor.getInstance());
    }

    @Override
    public void instantiating(Constructor constructor) {
        this.delegate.instantiating(constructor);
    }

    @Override
    public void instantiated(Constructor constructor, long duration) {
        this.delegate.instantiated(constructor, duration);
    }

    @Override
    public void instantiationFailed(Constructor constructor, Exception e) {
        this.delegate.instantiationFailed(constructor, e);
    }

    @Override
    public void invoking(Method method, Object instance) {
        this.delegate.invoking(method, instance);
    }

    @Override
    public void invoked(Method method, Object instance, long duration) {
        this.delegate.invoked(method, instance, duration);
    }

    @Override
    public void invocationFailed(Method method, Object instance, Exception e) {
        this.delegate.invocationFailed(method, instance, e);
    }

    @Override
    public void lifecycleInvocationFailed(Method method, Object instance, RuntimeException cause) {
        this.delegate.lifecycleInvocationFailed(method, instance, cause);
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        this.checkMonitor(monitor);
        if (this.delegate instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(monitor);
        } else {
            this.delegate = monitor;
        }
    }

    @Override
    public ComponentMonitor currentMonitor() {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
        }
        return this.delegate;
    }

    private void checkMonitor(ComponentMonitor monitor) {
        if (monitor == null) {
            throw new NullPointerException("monitor");
        }
    }
}

