/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.ComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.LifecycleManager;
import org.jetbrains.jet.internal.org.picocontainer.MutablePicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.Parameter;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoException;
import org.jetbrains.jet.internal.org.picocontainer.PicoInitializationException;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVerificationException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVisitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ComponentAdapterFactory;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ComponentMonitorStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.jetbrains.jet.internal.org.picocontainer.defaults.InstanceComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.defaults.LifecycleStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.VerifyingVisitor;
import org.jetbrains.jet.internal.org.picocontainer.monitors.DefaultComponentMonitor;

public class DefaultPicoContainer
implements Serializable,
MutablePicoContainer,
ComponentMonitorStrategy {
    private Map componentKeyToAdapterCache = new HashMap();
    private ComponentAdapterFactory componentAdapterFactory;
    private PicoContainer parent;
    private Set children = new HashSet();
    private List componentAdapters = new ArrayList();
    private List orderedComponentAdapters = new ArrayList();
    private boolean started = false;
    private boolean disposed = false;
    private Set childrenStarted = new HashSet();
    private LifecycleManager lifecycleManager = new OrderedComponentAdapterLifecycleManager();
    private LifecycleStrategy lifecycleStrategyForInstanceRegistrations;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        this(componentAdapterFactory, (LifecycleStrategy)new DefaultLifecycleStrategy(new DefaultComponentMonitor()), parent);
    }

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory, LifecycleStrategy lifecycleStrategyForInstanceRegistrations, PicoContainer parent) {
        if (componentAdapterFactory == null) {
            throw new NullPointerException("componentAdapterFactory");
        }
        if (lifecycleStrategyForInstanceRegistrations == null) {
            throw new NullPointerException("lifecycleStrategyForInstanceRegistrations");
        }
        this.componentAdapterFactory = componentAdapterFactory;
        this.lifecycleStrategyForInstanceRegistrations = lifecycleStrategyForInstanceRegistrations;
        this.parent = parent == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance(parent);
    }

    public DefaultPicoContainer(ComponentMonitor monitor, PicoContainer parent) {
        this(new DefaultComponentAdapterFactory(monitor), parent);
        this.lifecycleStrategyForInstanceRegistrations = new DefaultLifecycleStrategy(monitor);
    }

    public DefaultPicoContainer(ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        this(new DefaultComponentAdapterFactory(monitor, lifecycleStrategy), lifecycleStrategy, parent);
    }

    public DefaultPicoContainer(LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        this(new DefaultComponentMonitor(), lifecycleStrategy, parent);
    }

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this(componentAdapterFactory, null);
    }

    public DefaultPicoContainer(ComponentMonitor monitor) {
        this(monitor, (LifecycleStrategy)new DefaultLifecycleStrategy(monitor), null);
    }

    public DefaultPicoContainer(PicoContainer parent) {
        this(new DefaultComponentAdapterFactory(), parent);
    }

    public DefaultPicoContainer() {
        this(new DefaultComponentAdapterFactory(), null);
    }

    @Override
    public Collection getComponentAdapters() {
        return Collections.unmodifiableList(this.componentAdapters);
    }

    @Override
    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.get(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Override
    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = ((ComponentAdapter)found.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @Override
    public List getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.getComponentAdapters()) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        return found;
    }

    @Override
    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    @Override
    public ComponentAdapter unregisterComponent(Object componentKey) {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        this.orderedComponentAdapters.remove(adapter);
        return adapter;
    }

    @Override
    public ComponentAdapter registerComponentInstance(Object component) {
        return this.registerComponentInstance(component.getClass(), component);
    }

    @Override
    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) {
        InstanceComponentAdapter componentAdapter = new InstanceComponentAdapter(componentKey, componentInstance, this.lifecycleStrategyForInstanceRegistrations);
        return this.registerComponent(componentAdapter);
    }

    @Override
    public ComponentAdapter registerComponentImplementation(Class componentImplementation) {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    @Override
    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) {
        return this.registerComponentImplementation(componentKey, componentImplementation, (Parameter[])null);
    }

    @Override
    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        return this.registerComponent(componentAdapter);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, List parameters) {
        Parameter[] parametersAsArray = parameters.toArray(new Parameter[parameters.size()]);
        return this.registerComponentImplementation(componentKey, componentImplementation, parametersAsArray);
    }

    private void addOrderedComponentAdapter(ComponentAdapter componentAdapter) {
        if (!this.orderedComponentAdapters.contains(componentAdapter)) {
            this.orderedComponentAdapters.add(componentAdapter);
        }
    }

    @Override
    public List getComponentInstances() throws PicoException {
        return this.getComponentInstancesOfType(class$java$lang$Object == null ? (class$java$lang$Object = DefaultPicoContainer.class$("java.lang.Object")) : class$java$lang$Object);
    }

    @Override
    public List getComponentInstancesOfType(Class componentType) {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<ComponentAdapter, Object> adapterToInstanceMap = new HashMap<ComponentAdapter, Object>();
        for (ComponentAdapter componentAdapter : this.componentAdapters) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            Object componentInstance = this.getInstance(componentAdapter);
            adapterToInstanceMap.put(componentAdapter, componentInstance);
            this.addOrderedComponentAdapter(componentAdapter);
        }
        ArrayList result = new ArrayList();
        for (Object componentAdapter : this.orderedComponentAdapters) {
            Object componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentInstance);
        }
        return result;
    }

    @Override
    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter componentAdapter = this.getComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return this.getInstance(componentAdapter);
        }
        return null;
    }

    @Override
    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    private Object getInstance(ComponentAdapter componentAdapter) {
        boolean isLocal = this.componentAdapters.contains(componentAdapter);
        if (isLocal) {
            PicoException firstLevelException = null;
            Object instance = null;
            try {
                instance = componentAdapter.getComponentInstance(this);
            }
            catch (PicoInitializationException e) {
                firstLevelException = e;
            }
            catch (PicoIntrospectionException e) {
                firstLevelException = e;
            }
            if (firstLevelException != null) {
                if (this.parent != null && (instance = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
                    return instance;
                }
                throw firstLevelException;
            }
            this.addOrderedComponentAdapter(componentAdapter);
            return instance;
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    @Override
    public PicoContainer getParent() {
        return this.parent;
    }

    @Override
    public ComponentAdapter unregisterComponentByInstance(Object componentInstance) {
        Collection componentAdapters = this.getComponentAdapters();
        for (ComponentAdapter componentAdapter : componentAdapters) {
            if (!this.getInstance(componentAdapter).equals(componentInstance)) continue;
            return this.unregisterComponent(componentAdapter.getComponentKey());
        }
        return null;
    }

    @Override
    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse(this);
    }

    @Override
    public void start() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        this.lifecycleManager.start(this);
        this.childrenStarted.clear();
        for (PicoContainer child : this.children) {
            this.childrenStarted.add(new Integer(child.hashCode()));
            child.start();
        }
    }

    @Override
    public void stop() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        if (!this.started) {
            throw new IllegalStateException("Not started");
        }
        for (PicoContainer child : this.children) {
            if (!this.childStarted(child)) continue;
            child.stop();
        }
        this.lifecycleManager.stop(this);
        this.started = false;
    }

    private boolean childStarted(PicoContainer child) {
        return this.childrenStarted.contains(new Integer(child.hashCode()));
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        for (PicoContainer child : this.children) {
            child.dispose();
        }
        this.lifecycleManager.dispose(this);
        this.disposed = true;
    }

    @Override
    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer(this.componentAdapterFactory, this.lifecycleStrategyForInstanceRegistrations, (PicoContainer)this);
        this.addChildContainer(pc);
        return pc;
    }

    @Override
    public boolean addChildContainer(PicoContainer child) {
        if (this.children.add(child)) {
            if (this.started) {
                this.childrenStarted.add(new Integer(child.hashCode()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeChildContainer(PicoContainer child) {
        boolean result = this.children.remove(child);
        return result;
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitContainer(this);
        ArrayList componentAdapters = new ArrayList(this.getComponentAdapters());
        for (ComponentAdapter componentAdapter : componentAdapters) {
            componentAdapter.accept(visitor);
        }
        ArrayList allChildren = new ArrayList(this.children);
        for (PicoContainer child : allChildren) {
            child.accept(visitor);
        }
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        if (this.componentAdapterFactory instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.componentAdapterFactory)).changeMonitor(monitor);
        }
        for (Object adapter : this.componentAdapters) {
            if (!(adapter instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)adapter).changeMonitor(monitor);
        }
        for (Object child : this.children) {
            if (!(child instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)child).changeMonitor(monitor);
        }
    }

    @Override
    public ComponentMonitor currentMonitor() {
        if (this.componentAdapterFactory instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.componentAdapterFactory)).currentMonitor();
        }
        for (Object adapter : this.componentAdapters) {
            if (!(adapter instanceof ComponentMonitorStrategy)) continue;
            return ((ComponentMonitorStrategy)adapter).currentMonitor();
        }
        for (Object child : this.children) {
            if (!(child instanceof ComponentMonitorStrategy)) continue;
            return ((ComponentMonitorStrategy)child).currentMonitor();
        }
        throw new PicoIntrospectionException("No component monitor found in container or its children");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class OrderedComponentAdapterLifecycleManager
    implements Serializable,
    LifecycleManager {
        private List startedComponentAdapters = new ArrayList();

        private OrderedComponentAdapterLifecycleManager() {
        }

        @Override
        public void start(PicoContainer node) {
            LifecycleManager manager;
            Collection adapters = DefaultPicoContainer.this.getComponentAdapters();
            for (ComponentAdapter adapter : adapters) {
                if (!(adapter instanceof LifecycleManager) || !(manager = (LifecycleManager)((Object)adapter)).hasLifecycle()) continue;
                adapter.getComponentInstance(node);
                DefaultPicoContainer.this.addOrderedComponentAdapter(adapter);
            }
            adapters = DefaultPicoContainer.this.orderedComponentAdapters;
            this.startedComponentAdapters.clear();
            for (ComponentAdapter adapter : adapters) {
                if (!(adapter instanceof LifecycleManager)) continue;
                manager = (LifecycleManager)((Object)adapter);
                manager.start(node);
                this.startedComponentAdapters.add(adapter);
            }
        }

        @Override
        public void stop(PicoContainer node) {
            List adapters = this.startedComponentAdapters;
            for (int i = adapters.size() - 1; 0 <= i; --i) {
                Object adapter = adapters.get(i);
                if (!(adapter instanceof LifecycleManager)) continue;
                LifecycleManager manager = (LifecycleManager)adapter;
                manager.stop(node);
            }
        }

        @Override
        public void dispose(PicoContainer node) {
            List adapters = DefaultPicoContainer.this.orderedComponentAdapters;
            for (int i = adapters.size() - 1; 0 <= i; --i) {
                Object adapter = adapters.get(i);
                if (!(adapter instanceof LifecycleManager)) continue;
                LifecycleManager manager = (LifecycleManager)adapter;
                manager.dispose(node);
            }
        }

        @Override
        public boolean hasLifecycle() {
            throw new UnsupportedOperationException("Should not have been called");
        }
    }
}

