/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.io.Serializable;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.ComponentMonitor;
import org.jetbrains.jet.internal.org.picocontainer.LifecycleManager;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoInitializationException;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVisitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.ComponentMonitorStrategy;
import org.jetbrains.jet.internal.org.picocontainer.defaults.LifecycleStrategy;

public class DecoratingComponentAdapter
implements Serializable,
ComponentAdapter,
LifecycleManager,
ComponentMonitorStrategy,
LifecycleStrategy {
    private ComponentAdapter delegate;

    public DecoratingComponentAdapter(ComponentAdapter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getComponentKey() {
        return this.delegate.getComponentKey();
    }

    @Override
    public Class getComponentImplementation() {
        return this.delegate.getComponentImplementation();
    }

    @Override
    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
        return this.delegate.getComponentInstance(container);
    }

    @Override
    public void verify(PicoContainer container) throws PicoIntrospectionException {
        this.delegate.verify(container);
    }

    public ComponentAdapter getDelegate() {
        return this.delegate;
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter(this);
        this.delegate.accept(visitor);
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(monitor);
        }
    }

    @Override
    public ComponentMonitor currentMonitor() {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
        }
        throw new PicoIntrospectionException("No component monitor found in delegate");
    }

    @Override
    public void start(PicoContainer container) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).start(container);
        }
    }

    @Override
    public void stop(PicoContainer container) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).stop(container);
        }
    }

    @Override
    public void dispose(PicoContainer container) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).dispose(container);
        }
    }

    @Override
    public boolean hasLifecycle() {
        if (this.delegate instanceof LifecycleManager) {
            return ((LifecycleManager)((Object)this.delegate)).hasLifecycle();
        }
        if (this.delegate instanceof LifecycleStrategy) {
            return ((LifecycleStrategy)((Object)this.delegate)).hasLifecycle(this.delegate.getComponentImplementation());
        }
        return false;
    }

    @Override
    public void start(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).start(component);
        }
    }

    @Override
    public void stop(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).stop(component);
        }
    }

    @Override
    public void dispose(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).dispose(component);
        }
    }

    @Override
    public boolean hasLifecycle(Class type) {
        if (this.delegate instanceof LifecycleStrategy) {
            return ((LifecycleStrategy)((Object)this.delegate)).hasLifecycle(type);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getPrintableClassName());
        buffer.append(" delegate=");
        buffer.append(this.delegate);
        buffer.append("]");
        return buffer.toString();
    }

    private String getPrintableClassName() {
        String name = this.getClass().getName();
        if ((name = name.substring(name.lastIndexOf(46) + 1)).endsWith("ComponentAdapter")) {
            name = new StringBuffer().append(name.substring(0, name.length() - "ComponentAdapter".length())).append("CA").toString();
        }
        return name;
    }
}

