/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Map;

public class CustomPermissionsURLClassLoader
extends URLClassLoader {
    private final Map permissionsMap;
    static /* synthetic */ Class class$org$picocontainer$defaults$CustomPermissionsURLClassLoader;

    public CustomPermissionsURLClassLoader(URL[] urls, Map permissionsMap, ClassLoader parent) {
        super(urls, parent);
        this.permissionsMap = permissionsMap;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw this.decorateException(name, e);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            throw this.decorateException(name, e);
        }
    }

    private ClassNotFoundException decorateException(String name, ClassNotFoundException e) {
        if (name.startsWith("class ")) {
            return new ClassNotFoundException(new StringBuffer().append("Class '").append(name).append("' is not a classInstance.getName(). ").append("It's a classInstance.toString(). The clue is that it starts with 'class ', no classname contains a space.").toString());
        }
        ClassLoader classLoader = this;
        StringBuffer sb = new StringBuffer("'").append(name).append("' classloader stack [");
        while (classLoader != null) {
            sb.append(((Object)classLoader).toString()).append("\n");
            final CustomPermissionsURLClassLoader cl = classLoader;
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getParent();
                }
            });
        }
        return new ClassNotFoundException(sb.append("]").toString(), e);
    }

    public String toString() {
        String result = new StringBuffer().append((class$org$picocontainer$defaults$CustomPermissionsURLClassLoader == null ? (class$org$picocontainer$defaults$CustomPermissionsURLClassLoader = CustomPermissionsURLClassLoader.class$("org.jetbrains.jet.internal.org.picocontainer.defaults.CustomPermissionsURLClassLoader")) : class$org$picocontainer$defaults$CustomPermissionsURLClassLoader).getName()).append(" ").append(System.identityHashCode(this)).append(":").toString();
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            result = new StringBuffer().append(result).append("\n\t").append(url.toString()).toString();
        }
        return result;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        return (Permissions)this.permissionsMap.get(codeSource.getLocation());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

