/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.Parameter;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoException;
import org.jetbrains.jet.internal.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVisitor;

public class ConstantParameter
implements Serializable,
Parameter {
    private final Object value;

    public ConstantParameter(Object value) {
        this.value = value;
    }

    @Override
    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        return this.value;
    }

    @Override
    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        try {
            this.verify(container, adapter, expectedType);
            return true;
        }
        catch (PicoIntrospectionException e) {
            return false;
        }
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoException {
        if (!this.checkPrimitive(expectedType) && !expectedType.isInstance(this.value)) {
            throw new PicoIntrospectionException(new StringBuffer().append(expectedType.getClass().getName()).append(" is not assignable from ").append(this.value.getClass().getName()).toString());
        }
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private boolean checkPrimitive(Class expectedType) {
        try {
            if (expectedType.isPrimitive()) {
                Field field = this.value.getClass().getField("TYPE");
                Class type = (Class)field.get(this.value);
                return expectedType.isAssignableFrom(type);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }
}

