/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.Parameter;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoVisitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.jet.internal.org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class BasicComponentParameter
implements Serializable,
Parameter {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    @Override
    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        return this.resolveAdapter(container, adapter, expectedType) != null;
    }

    @Override
    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
        if (componentAdapter != null) {
            return container.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
        if (componentAdapter == null) {
            HashSet<Class> set = new HashSet<Class>();
            set.add(expectedType);
            throw new UnsatisfiableDependenciesException(adapter, set, container);
        }
        componentAdapter.verify(container);
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private ComponentAdapter resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter result = this.getTargetAdapter(container, expectedType, adapter);
        if (result == null) {
            return null;
        }
        if (!expectedType.isAssignableFrom(result.getComponentImplementation())) {
            if (expectedType.isPrimitive()) {
                try {
                    Field field = result.getComponentImplementation().getField("TYPE");
                    Class type = (Class)field.get(result.getComponentInstance(null));
                    if (expectedType.isAssignableFrom(type)) {
                        return result;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }
        return result;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container, Class expectedType, ComponentAdapter excludeAdapter) {
        if (this.componentKey != null) {
            return container.getComponentAdapter(this.componentKey);
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapterOfType(expectedType);
        }
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter byKey = container.getComponentAdapter(expectedType);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return byKey;
        }
        List found = container.getComponentAdaptersOfType(expectedType);
        ComponentAdapter exclude = null;
        for (ComponentAdapter work : found) {
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found.remove(exclude);
        if (found.size() == 0) {
            if (container.getParent() != null) {
                return container.getParent().getComponentAdapterOfType(expectedType);
            }
            return null;
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = ((ComponentAdapter)found.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType, foundClasses);
    }
}

