/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.picocontainer.alternatives;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.jet.internal.org.picocontainer.ComponentAdapter;
import org.jetbrains.jet.internal.org.picocontainer.PicoContainer;
import org.jetbrains.jet.internal.org.picocontainer.PicoException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVerificationException;
import org.jetbrains.jet.internal.org.picocontainer.PicoVisitor;
import org.jetbrains.jet.internal.org.picocontainer.defaults.VerifyingVisitor;

public class ImmutablePicoContainer
implements Serializable,
PicoContainer {
    private PicoContainer delegate;

    public ImmutablePicoContainer(PicoContainer delegate) {
        if (delegate == null) {
            throw new NullPointerException("You must pass in a picoContainer instance");
        }
        this.delegate = delegate;
    }

    @Override
    public Object getComponentInstance(Object componentKey) {
        return this.delegate.getComponentInstance(componentKey);
    }

    @Override
    public Object getComponentInstanceOfType(Class componentType) {
        return this.delegate.getComponentInstanceOfType(componentType);
    }

    @Override
    public List getComponentInstances() {
        return this.delegate.getComponentInstances();
    }

    @Override
    public synchronized PicoContainer getParent() {
        return this.delegate.getParent();
    }

    @Override
    public ComponentAdapter getComponentAdapter(Object componentKey) {
        return this.delegate.getComponentAdapter(componentKey);
    }

    @Override
    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        return this.delegate.getComponentAdapterOfType(componentType);
    }

    @Override
    public Collection getComponentAdapters() {
        return this.delegate.getComponentAdapters();
    }

    @Override
    public List getComponentAdaptersOfType(Class componentType) {
        return this.delegate.getComponentAdaptersOfType(componentType);
    }

    @Override
    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse(this);
    }

    @Override
    public List getComponentInstancesOfType(Class type) throws PicoException {
        return this.delegate.getComponentInstancesOfType(type);
    }

    @Override
    public void accept(PicoVisitor visitor) {
        this.delegate.accept(visitor);
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException("This container is immutable, start() is not allowed");
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("This container is immutable, stop() is not allowed");
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException("This container is immutable, dispose() is not allowed");
    }
}

