/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.objectweb.asm.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jet.internal.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Attribute;
import org.jetbrains.jet.internal.org.objectweb.asm.Label;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodAdapter;
import org.jetbrains.jet.internal.org.objectweb.asm.MethodVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Opcodes;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.util.CheckAnnotationAdapter;
import org.jetbrains.jet.internal.org.objectweb.asm.util.CheckMethodAdapter$1;

public class CheckMethodAdapter
extends MethodAdapter {
    private boolean startCode;
    private boolean endCode;
    private boolean endMethod;
    private final Map labels;
    private static final int[] TYPE;
    private static Field labelStatusField;
    static /* synthetic */ Class class$org$objectweb$asm$Label;

    public CheckMethodAdapter(MethodVisitor methodVisitor) {
        this(methodVisitor, new HashMap());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map map) {
        super(methodVisitor);
        this.labels = map;
    }

    public CheckMethodAdapter(int n, String string, String string2, MethodVisitor methodVisitor, Map map) {
        this(new CheckMethodAdapter$1(n, string, string2, null, null, methodVisitor), map);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string, false);
        return new CheckAnnotationAdapter(this.mv.visitAnnotation(string, bl));
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.checkEndMethod();
        return new CheckAnnotationAdapter(this.mv.visitAnnotationDefault(), false);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string, false);
        return new CheckAnnotationAdapter(this.mv.visitParameterAnnotation(n, string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkEndMethod();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.mv.visitAttribute(attribute);
    }

    @Override
    public void visitCode() {
        this.startCode = true;
        this.mv.visitCode();
    }

    @Override
    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        int n5;
        int n6;
        switch (n) {
            case -1: 
            case 0: {
                n6 = Integer.MAX_VALUE;
                n5 = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                n6 = 0;
                n5 = 0;
                break;
            }
            case 4: {
                n6 = 0;
                n5 = 1;
                break;
            }
            case 1: 
            case 2: {
                n6 = 3;
                n5 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer().append("Invalid frame type ").append(n).toString());
            }
        }
        if (n2 > n6) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid nLocal=").append(n2).append(" for frame type ").append(n).toString());
        }
        if (n3 > n5) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid nStack=").append(n3).append(" for frame type ").append(n).toString());
        }
        if (n != 2) {
            if (n2 > 0 && (objectArray == null || objectArray.length < n2)) {
                throw new IllegalArgumentException("Array local[] is shorter than nLocal");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                CheckMethodAdapter.checkFrameValue(objectArray[n4]);
            }
        }
        if (n3 > 0 && (objectArray2 == null || objectArray2.length < n3)) {
            throw new IllegalArgumentException("Array stack[] is shorter than nStack");
        }
        for (n4 = 0; n4 < n3; ++n4) {
            CheckMethodAdapter.checkFrameValue(objectArray2[n4]);
        }
        this.mv.visitFrame(n, n2, objectArray, n3, objectArray2);
    }

    @Override
    public void visitInsn(int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0);
        this.mv.visitInsn(n);
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 1);
        switch (n) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(n2, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(n2, "Invalid operand");
                break;
            }
            default: {
                if (n2 >= 4 && n2 <= 11) break;
                throw new IllegalArgumentException(new StringBuffer().append("Invalid operand (must be an array type code T_...): ").append(n2).toString());
            }
        }
        this.mv.visitIntInsn(n, n2);
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 2);
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid variable index");
        this.mv.visitVarInsn(n, n2);
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 3);
        CheckMethodAdapter.checkInternalName(string, "type");
        if (n == 187 && string.charAt(0) == '[') {
            throw new IllegalArgumentException(new StringBuffer().append("NEW cannot be used to create arrays: ").append(string).toString());
        }
        this.mv.visitTypeInsn(n, string);
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 4);
        CheckMethodAdapter.checkInternalName(string, "owner");
        CheckMethodAdapter.checkIdentifier(string2, "name");
        CheckMethodAdapter.checkDesc(string3, false);
        this.mv.visitFieldInsn(n, string, string2, string3);
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 5);
        CheckMethodAdapter.checkMethodIdentifier(string2, "name");
        CheckMethodAdapter.checkInternalName(string, "owner");
        CheckMethodAdapter.checkMethodDesc(string3);
        if (n == 186 && string != "java/lang/dyn/Dynamic") {
            throw new IllegalArgumentException("INVOKEDYNAMIC cannot be used with another owner than INVOKEDYNAMIC_OWNER");
        }
        this.mv.visitMethodInsn(n, string, string2, string3);
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 6);
        this.checkLabel(label, false, "label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        this.mv.visitJumpInsn(n, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, new Integer(this.labels.size()));
        this.mv.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.checkStartCode();
        this.checkEndCode();
        if (!(object instanceof Type)) {
            CheckMethodAdapter.checkConstant(object);
        }
        this.mv.visitLdcInsn(object);
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid variable index");
        CheckMethodAdapter.checkSignedShort(n2, "Invalid increment");
        this.mv.visitIincInsn(n, n2);
    }

    @Override
    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.checkStartCode();
        this.checkEndCode();
        if (n2 < n) {
            throw new IllegalArgumentException(new StringBuffer().append("Max = ").append(n2).append(" must be greater than or equal to min = ").append(n).toString());
        }
        this.checkLabel(label, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (labelArray == null || labelArray.length != n2 - n + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], false, new StringBuffer().append("label at index ").append(i).toString());
            CheckMethodAdapter.checkNonDebugLabel(labelArray[i]);
        }
        this.mv.visitTableSwitchInsn(n, n2, label, labelArray);
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.checkEndCode();
        this.checkStartCode();
        this.checkLabel(label, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], false, new StringBuffer().append("label at index ").append(i).toString());
            CheckMethodAdapter.checkNonDebugLabel(labelArray[i]);
        }
        this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkDesc(string, false);
        if (string.charAt(0) != '[') {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor (must be an array type descriptor): ").append(string).toString());
        }
        if (n < 1) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid dimensions (must be greater than 0): ").append(n).toString());
        }
        if (n > string.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid dimensions (must not be greater than dims(desc)): ").append(n).toString());
        }
        this.mv.visitMultiANewArrayInsn(string, n);
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "start label");
        this.checkLabel(label2, false, "end label");
        this.checkLabel(label3, false, "handler label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        CheckMethodAdapter.checkNonDebugLabel(label2);
        CheckMethodAdapter.checkNonDebugLabel(label3);
        if (this.labels.get(label) != null || this.labels.get(label2) != null || this.labels.get(label3) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (string != null) {
            CheckMethodAdapter.checkInternalName(string, "type");
        }
        this.mv.visitTryCatchBlock(label, label2, label3, string);
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkIdentifier(string, "name");
        CheckMethodAdapter.checkDesc(string2, false);
        this.checkLabel(label, true, "start label");
        this.checkLabel(label2, true, "end label");
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid variable index");
        int n2 = (Integer)this.labels.get(label);
        int n3 = (Integer)this.labels.get(label2);
        if (n3 < n2) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.mv.visitLocalVariable(string, string2, string3, label, label2, n);
    }

    @Override
    public void visitLineNumber(int n, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid line number");
        this.checkLabel(label, true, "start label");
        this.mv.visitLineNumber(n, label);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        this.endCode = true;
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid max locals");
        this.mv.visitMaxs(n, n2);
    }

    @Override
    public void visitEnd() {
        this.checkEndMethod();
        this.endMethod = true;
        this.mv.visitEnd();
    }

    void checkStartCode() {
        if (!this.startCode) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    void checkEndCode() {
        if (this.endCode) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    void checkEndMethod() {
        if (this.endMethod) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    static void checkFrameValue(Object object) {
        if (object == Opcodes.TOP || object == Opcodes.INTEGER || object == Opcodes.FLOAT || object == Opcodes.LONG || object == Opcodes.DOUBLE || object == Opcodes.NULL || object == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (object instanceof String) {
            CheckMethodAdapter.checkInternalName((String)object, "Invalid stack frame value");
            return;
        }
        if (!(object instanceof Label)) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid stack frame value: ").append(object).toString());
        }
    }

    static void checkOpcode(int n, int n2) {
        if (n < 0 || n > 199 || TYPE[n] != n2) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid opcode: ").append(n).toString());
        }
    }

    static void checkSignedByte(int n, String string) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException(new StringBuffer().append(string).append(" (must be a signed byte): ").append(n).toString());
        }
    }

    static void checkSignedShort(int n, String string) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuffer().append(string).append(" (must be a signed short): ").append(n).toString());
        }
    }

    static void checkUnsignedShort(int n, String string) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(new StringBuffer().append(string).append(" (must be an unsigned short): ").append(n).toString());
        }
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid constant: ").append(object).toString());
        }
    }

    static void checkIdentifier(String string, String string2) {
        CheckMethodAdapter.checkIdentifier(string, 0, -1, string2);
    }

    static void checkIdentifier(String string, int n, int n2, String string2) {
        if (string == null || (n2 == -1 ? string.length() <= n : n2 <= n)) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string2).append(" (must not be null or empty)").toString());
        }
        if (!Character.isJavaIdentifierStart(string.charAt(n))) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string2).append(" (must be a valid Java identifier): ").append(string).toString());
        }
        int n3 = n2 == -1 ? string.length() : n2;
        for (int i = n + 1; i < n3; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string2).append(" (must be a valid Java identifier): ").append(string).toString());
        }
    }

    static void checkMethodIdentifier(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string2).append(" (must not be null or empty)").toString());
        }
        if ("<init>".equals(string) || "<clinit>".equals(string)) {
            return;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string2).append(" (must be a '<init>', '<clinit>' or a valid Java identifier): ").append(string).toString());
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string2).append(" (must be '<init>' or '<clinit>' or a valid Java identifier): ").append(string).toString());
        }
    }

    static void checkInternalName(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string2).append(" (must not be null or empty)").toString());
        }
        if (string.charAt(0) == '[') {
            CheckMethodAdapter.checkDesc(string, false);
        } else {
            CheckMethodAdapter.checkInternalName(string, 0, -1, string2);
        }
    }

    static void checkInternalName(String string, int n, int n2, String string2) {
        int n3 = n2 == -1 ? string.length() : n2;
        try {
            int n4;
            int n5 = n;
            do {
                if ((n4 = string.indexOf(47, n5 + 1)) == -1 || n4 > n3) {
                    n4 = n3;
                }
                CheckMethodAdapter.checkIdentifier(string, n5, n4, null);
                n5 = n4 + 1;
            } while (n4 != n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string2).append(" (must be a fully qualified class name in internal form): ").append(string).toString());
        }
    }

    static void checkDesc(String string, boolean bl) {
        int n = CheckMethodAdapter.checkDesc(string, 0, bl);
        if (n != string.length()) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
        }
    }

    static int checkDesc(String string, int n, boolean bl) {
        if (string == null || n >= string.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (string.charAt(n)) {
            case 'V': {
                if (bl) {
                    return n + 1;
                }
                throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
            case '[': {
                int n2;
                for (n2 = n + 1; n2 < string.length() && string.charAt(n2) == '['; ++n2) {
                }
                if (n2 < string.length()) {
                    return CheckMethodAdapter.checkDesc(string, n2, false);
                }
                throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
            }
            case 'L': {
                int n3 = string.indexOf(59, n);
                if (n3 == -1 || n3 - n < 2) {
                    throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
                }
                try {
                    CheckMethodAdapter.checkInternalName(string, n + 1, n3, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
                }
                return n3 + 1;
            }
        }
        throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
    }

    static void checkMethodDesc(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (string.charAt(0) != '(' || string.length() < 3) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
        }
        int n = 1;
        if (string.charAt(n) != ')') {
            do {
                if (string.charAt(n) != 'V') continue;
                throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
            } while ((n = CheckMethodAdapter.checkDesc(string, n, false)) < string.length() && string.charAt(n) != ')');
        }
        if ((n = CheckMethodAdapter.checkDesc(string, n + 1, true)) != string.length()) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid descriptor: ").append(string).toString());
        }
    }

    static void checkClassSignature(String string) {
        int n = 0;
        if (CheckMethodAdapter.getChar(string, 0) == '<') {
            n = CheckMethodAdapter.checkFormalTypeParameters(string, n);
        }
        n = CheckMethodAdapter.checkClassTypeSignature(string, n);
        while (CheckMethodAdapter.getChar(string, n) == 'L') {
            n = CheckMethodAdapter.checkClassTypeSignature(string, n);
        }
        if (n != string.length()) {
            throw new IllegalArgumentException(new StringBuffer().append(string).append(": error at index ").append(n).toString());
        }
    }

    static void checkMethodSignature(String string) {
        int n = 0;
        if (CheckMethodAdapter.getChar(string, 0) == '<') {
            n = CheckMethodAdapter.checkFormalTypeParameters(string, n);
        }
        n = CheckMethodAdapter.checkChar('(', string, n);
        while ("ZCBSIFJDL[T".indexOf(CheckMethodAdapter.getChar(string, n)) != -1) {
            n = CheckMethodAdapter.checkTypeSignature(string, n);
        }
        n = CheckMethodAdapter.getChar(string, n = CheckMethodAdapter.checkChar(')', string, n)) == 'V' ? ++n : CheckMethodAdapter.checkTypeSignature(string, n);
        while (CheckMethodAdapter.getChar(string, n) == '^') {
            if (CheckMethodAdapter.getChar(string, ++n) == 'L') {
                n = CheckMethodAdapter.checkClassTypeSignature(string, n);
                continue;
            }
            n = CheckMethodAdapter.checkTypeVariableSignature(string, n);
        }
        if (n != string.length()) {
            throw new IllegalArgumentException(new StringBuffer().append(string).append(": error at index ").append(n).toString());
        }
    }

    static void checkFieldSignature(String string) {
        int n = CheckMethodAdapter.checkFieldTypeSignature(string, 0);
        if (n != string.length()) {
            throw new IllegalArgumentException(new StringBuffer().append(string).append(": error at index ").append(n).toString());
        }
    }

    private static int checkFormalTypeParameters(String string, int n) {
        n = CheckMethodAdapter.checkChar('<', string, n);
        n = CheckMethodAdapter.checkFormalTypeParameter(string, n);
        while (CheckMethodAdapter.getChar(string, n) != '>') {
            n = CheckMethodAdapter.checkFormalTypeParameter(string, n);
        }
        return n + 1;
    }

    private static int checkFormalTypeParameter(String string, int n) {
        n = CheckMethodAdapter.checkIdentifier(string, n);
        if ("L[T".indexOf(CheckMethodAdapter.getChar(string, n = CheckMethodAdapter.checkChar(':', string, n))) != -1) {
            n = CheckMethodAdapter.checkFieldTypeSignature(string, n);
        }
        while (CheckMethodAdapter.getChar(string, n) == ':') {
            n = CheckMethodAdapter.checkFieldTypeSignature(string, n + 1);
        }
        return n;
    }

    private static int checkFieldTypeSignature(String string, int n) {
        switch (CheckMethodAdapter.getChar(string, n)) {
            case 'L': {
                return CheckMethodAdapter.checkClassTypeSignature(string, n);
            }
            case '[': {
                return CheckMethodAdapter.checkTypeSignature(string, n + 1);
            }
        }
        return CheckMethodAdapter.checkTypeVariableSignature(string, n);
    }

    private static int checkClassTypeSignature(String string, int n) {
        n = CheckMethodAdapter.checkChar('L', string, n);
        n = CheckMethodAdapter.checkIdentifier(string, n);
        while (CheckMethodAdapter.getChar(string, n) == '/') {
            n = CheckMethodAdapter.checkIdentifier(string, n + 1);
        }
        if (CheckMethodAdapter.getChar(string, n) == '<') {
            n = CheckMethodAdapter.checkTypeArguments(string, n);
        }
        while (CheckMethodAdapter.getChar(string, n) == '.') {
            if (CheckMethodAdapter.getChar(string, n = CheckMethodAdapter.checkIdentifier(string, n + 1)) != '<') continue;
            n = CheckMethodAdapter.checkTypeArguments(string, n);
        }
        return CheckMethodAdapter.checkChar(';', string, n);
    }

    private static int checkTypeArguments(String string, int n) {
        n = CheckMethodAdapter.checkChar('<', string, n);
        n = CheckMethodAdapter.checkTypeArgument(string, n);
        while (CheckMethodAdapter.getChar(string, n) != '>') {
            n = CheckMethodAdapter.checkTypeArgument(string, n);
        }
        return n + 1;
    }

    private static int checkTypeArgument(String string, int n) {
        char c = CheckMethodAdapter.getChar(string, n);
        if (c == '*') {
            return n + 1;
        }
        if (c == '+' || c == '-') {
            ++n;
        }
        return CheckMethodAdapter.checkFieldTypeSignature(string, n);
    }

    private static int checkTypeVariableSignature(String string, int n) {
        n = CheckMethodAdapter.checkChar('T', string, n);
        n = CheckMethodAdapter.checkIdentifier(string, n);
        return CheckMethodAdapter.checkChar(';', string, n);
    }

    private static int checkTypeSignature(String string, int n) {
        switch (CheckMethodAdapter.getChar(string, n)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
        }
        return CheckMethodAdapter.checkFieldTypeSignature(string, n);
    }

    private static int checkIdentifier(String string, int n) {
        if (!Character.isJavaIdentifierStart(CheckMethodAdapter.getChar(string, n))) {
            throw new IllegalArgumentException(new StringBuffer().append(string).append(": identifier expected at index ").append(n).toString());
        }
        ++n;
        while (Character.isJavaIdentifierPart(CheckMethodAdapter.getChar(string, n))) {
            ++n;
        }
        return n;
    }

    private static int checkChar(char c, String string, int n) {
        if (CheckMethodAdapter.getChar(string, n) == c) {
            return n + 1;
        }
        throw new IllegalArgumentException(new StringBuffer().append(string).append(": '").append(c).append("' expected at index ").append(n).toString());
    }

    private static char getChar(String string, int n) {
        return n < string.length() ? string.charAt(n) : (char)'\u0000';
    }

    void checkLabel(Label label, boolean bl, String string) {
        if (label == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string).append(" (must not be null)").toString());
        }
        if (bl && this.labels.get(label) == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid ").append(string).append(" (must be visited first)").toString());
        }
    }

    private static void checkNonDebugLabel(Label label) {
        Field field = CheckMethodAdapter.getLabelStatusField();
        int n = 0;
        try {
            n = field == null ? 0 : (Integer)field.get(label);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Internal error");
        }
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("Labels used for debug info cannot be reused for control flow");
        }
    }

    private static Field getLabelStatusField() {
        if (labelStatusField == null && (labelStatusField = CheckMethodAdapter.getLabelField("a")) == null) {
            labelStatusField = CheckMethodAdapter.getLabelField("status");
        }
        return labelStatusField;
    }

    private static Field getLabelField(String string) {
        try {
            Field field = (class$org$objectweb$asm$Label == null ? (class$org$objectweb$asm$Label = CheckMethodAdapter.class$("org.jetbrains.jet.internal.org.objectweb.asm.Label")) : class$org$objectweb$asm$Label).getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = "BBBBBBBBBBBBBBBBCCIAADDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBDDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBJBBBBBBBBBBBBBBBBBBBBHHHHHHHHHHHHHHHHDKLBBBBBBFFFFGGGGGECEBBEEBBAMHHAA";
        TYPE = new int[string.length()];
        for (int i = 0; i < TYPE.length; ++i) {
            CheckMethodAdapter.TYPE[i] = string.charAt(i) - 65 - 1;
        }
    }
}

