/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.objectweb.asm.util;

import org.jetbrains.jet.internal.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.Attribute;
import org.jetbrains.jet.internal.org.objectweb.asm.FieldVisitor;
import org.jetbrains.jet.internal.org.objectweb.asm.util.CheckAnnotationAdapter;
import org.jetbrains.jet.internal.org.objectweb.asm.util.CheckMethodAdapter;

public class CheckFieldAdapter
implements FieldVisitor {
    private final FieldVisitor fv;
    private boolean end;

    public CheckFieldAdapter(FieldVisitor fieldVisitor) {
        this.fv = fieldVisitor;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkEnd();
        CheckMethodAdapter.checkDesc(string, false);
        return new CheckAnnotationAdapter(this.fv.visitAnnotation(string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkEnd();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.fv.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        this.fv.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

