/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.objectweb.asm.tree.analysis;

import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.internal.org.objectweb.asm.tree.analysis.Value;

public class BasicValue
implements Value {
    public static final Value UNINITIALIZED_VALUE = new BasicValue(null);
    public static final Value INT_VALUE = new BasicValue(Type.INT_TYPE);
    public static final Value FLOAT_VALUE = new BasicValue(Type.FLOAT_TYPE);
    public static final Value LONG_VALUE = new BasicValue(Type.LONG_TYPE);
    public static final Value DOUBLE_VALUE = new BasicValue(Type.DOUBLE_TYPE);
    public static final Value REFERENCE_VALUE = new BasicValue(Type.getObjectType("java/lang/Object"));
    public static final Value RETURNADDRESS_VALUE = new BasicValue(Type.VOID_TYPE);
    private final Type type;

    public BasicValue(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return this.type == Type.LONG_TYPE || this.type == Type.DOUBLE_TYPE ? 2 : 1;
    }

    public boolean isReference() {
        return this.type != null && (this.type.getSort() == 10 || this.type.getSort() == 9);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BasicValue) {
            if (this.type == null) {
                return ((BasicValue)object).type == null;
            }
            return this.type.equals(((BasicValue)object).type);
        }
        return false;
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public String toString() {
        if (this == UNINITIALIZED_VALUE) {
            return ".";
        }
        if (this == RETURNADDRESS_VALUE) {
            return "A";
        }
        if (this == REFERENCE_VALUE) {
            return "R";
        }
        return this.type.getDescriptor();
    }
}

