/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.mozilla.javascript;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.jet.internal.org.mozilla.javascript.Callable;
import org.jetbrains.jet.internal.org.mozilla.javascript.Context;
import org.jetbrains.jet.internal.org.mozilla.javascript.Scriptable;

public abstract class SecureCaller {
    private static final byte[] secureCallerImplBytecode = SecureCaller.loadBytecode();
    private static final Map<CodeSource, Map<ClassLoader, SoftReference<SecureCaller>>> callers = new WeakHashMap<CodeSource, Map<ClassLoader, SoftReference<SecureCaller>>>();

    public abstract Object call(Callable var1, Context var2, Scriptable var3, Scriptable var4, Object[] var5);

    private static byte[] loadBytecode() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return SecureCaller.loadBytecodePrivileged();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] loadBytecodePrivileged() {
        URL url = SecureCaller.class.getResource("SecureCallerImpl.clazz");
        try {
            InputStream in = url.openStream();
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while (true) {
                    int r;
                    if ((r = in.read()) == -1) {
                        byte[] byArray = bout.toByteArray();
                        return byArray;
                    }
                    bout.write(r);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static class SecureClassLoaderImpl
    extends SecureClassLoader {
        SecureClassLoaderImpl(ClassLoader parent) {
            super(parent);
        }

        Class<?> defineAndLinkClass(String name, byte[] bytes, CodeSource cs) {
            Class<?> cl = this.defineClass(name, bytes, 0, bytes.length, cs);
            this.resolveClass(cl);
            return cl;
        }
    }
}

