/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.kohsuke.args4j.spi;

import java.util.ArrayList;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineException;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineParser;
import org.jetbrains.jet.internal.org.kohsuke.args4j.OptionDef;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.OptionHandler;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Parameters;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Setter;

public class StringArrayOptionHandler
extends OptionHandler<String[]> {
    public StringArrayOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String[]> setter) {
        super(parser, option, setter);
    }

    @Override
    public String getDefaultMetaVariable() {
        return "STRING[]";
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        int counter = 0;
        ArrayList<String> values = new ArrayList<String>();
        while (true) {
            String param;
            try {
                param = params.getParameter(counter);
            }
            catch (CmdLineException ex) {
                break;
            }
            if (param.startsWith("-")) break;
            for (String str : param.split(" ")) {
                values.add(str);
            }
            ++counter;
        }
        Setter s = this.setter;
        s.addValue(values.toArray(new String[values.size()]));
        return counter;
    }
}

