/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.kohsuke.args4j.spi;

import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineException;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineParser;
import org.jetbrains.jet.internal.org.kohsuke.args4j.OptionDef;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Messages;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.OptionHandler;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Parameters;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Setter;

public abstract class OneArgumentOptionHandler<T>
extends OptionHandler<T> {
    public OneArgumentOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
        super(parser, option, setter);
    }

    @Override
    public String getDefaultMetaVariable() {
        return "N";
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String token = params.getParameter(0);
        try {
            T value = this.parse(token);
            this.setter.addValue(value);
        }
        catch (NumberFormatException ex) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(this.option.toString(), token));
        }
        return 1;
    }

    protected abstract T parse(String var1) throws NumberFormatException, CmdLineException;
}

