/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.kohsuke.args4j.spi;

import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineException;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineParser;
import org.jetbrains.jet.internal.org.kohsuke.args4j.OptionDef;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Messages;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.OptionHandler;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Parameters;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Setter;

public class EnumOptionHandler<T extends Enum<T>>
extends OptionHandler<T> {
    private final Class<T> enumType;

    public EnumOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter, Class<T> enumType) {
        super(parser, option, setter);
        this.enumType = enumType;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String s = params.getParameter(0);
        Enum value = null;
        for (Enum o : (Enum[])this.enumType.getEnumConstants()) {
            if (!o.name().equalsIgnoreCase(s)) continue;
            value = o;
            break;
        }
        if (value == null) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(this.option.toString(), s));
        }
        this.setter.addValue(value);
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        StringBuffer rv = new StringBuffer();
        rv.append("[");
        for (Enum t : (Enum[])this.enumType.getEnumConstants()) {
            rv.append(t).append(" | ");
        }
        rv.delete(rv.length() - 3, rv.length());
        rv.append("]");
        return rv.toString();
    }
}

