/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.kohsuke.args4j.spi;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineException;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineParser;
import org.jetbrains.jet.internal.org.kohsuke.args4j.OptionDef;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Messages;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.OptionHandler;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Parameters;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Setter;

public class BooleanOptionHandler
extends OptionHandler<Boolean> {
    private static final List<String> ACCEPTABLE_VALUES = Arrays.asList("true", "on", "yes", "1", "false", "off", "no", "0");

    public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
        super(parser, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        if (this.option.isArgument()) {
            String valueStr = params.getParameter(0).toLowerCase();
            int index = ACCEPTABLE_VALUES.indexOf(valueStr);
            if (index == -1) {
                throw new CmdLineException(Messages.ILLEGAL_BOOLEAN.format(valueStr));
            }
            this.setter.addValue(index < ACCEPTABLE_VALUES.size() / 2);
            return 1;
        }
        this.setter.addValue(true);
        return 0;
    }

    @Override
    public String getDefaultMetaVariable() {
        return null;
    }
}

