/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.kohsuke.args4j;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.jet.internal.org.kohsuke.args4j.CmdLineException;
import org.jetbrains.jet.internal.org.kohsuke.args4j.IllegalAnnotationError;
import org.jetbrains.jet.internal.org.kohsuke.args4j.Messages;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Setter;

final class MethodSetter
implements Setter {
    private final Object bean;
    private final Method m;

    public MethodSetter(Object bean, Method m) {
        this.bean = bean;
        this.m = m;
        if (m.getParameterTypes().length != 1) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_METHOD_SIGNATURE.format(m));
        }
    }

    public Class getType() {
        return this.m.getParameterTypes()[0];
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    public void addValue(Object value) throws CmdLineException {
        try {
            try {
                this.m.invoke(this.bean, value);
            }
            catch (IllegalAccessException _) {
                this.m.setAccessible(true);
                try {
                    this.m.invoke(this.bean, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof CmdLineException) {
                throw (CmdLineException)t;
            }
            if (t != null) {
                throw new CmdLineException(t);
            }
            throw new CmdLineException(e);
        }
    }
}

