/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.kohsuke.args4j;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.jetbrains.jet.internal.org.kohsuke.args4j.spi.Setter;

public class MapSetter
implements Setter {
    private final Field f;
    private final Object bean;

    public MapSetter(Object bean, Field f) {
        this.f = f;
        this.bean = bean;
    }

    public Class getType() {
        return this.f.getType();
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    public void addValue(Object value) {
        String mapValue;
        if (String.valueOf(value).indexOf(61) == -1) {
            throw new RuntimeException("An argument for setting a Map must contain a '='");
        }
        String[] parts = String.valueOf(value).split("=");
        String mapKey = parts[0];
        String string = mapValue = parts.length > 1 ? parts[1] : null;
        if (mapKey == null || mapKey.length() == 0) {
            throw new RuntimeException("A key must be set.");
        }
        try {
            this.addValue(mapKey, mapValue);
        }
        catch (IllegalAccessException _) {
            this.f.setAccessible(true);
            try {
                this.addValue(mapKey, mapValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    private void addValue(Object key, Object value) throws IllegalArgumentException, IllegalAccessException {
        HashMap<Object, Object> map = (HashMap<Object, Object>)this.f.get(this.bean);
        if (map == null) {
            map = new HashMap<Object, Object>();
            this.f.set(this.bean, map);
        }
        map.put(key, value);
    }
}

