/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.jdom;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jet.internal.org.jdom.Document;
import org.jetbrains.jet.internal.org.jdom.Element;
import org.jetbrains.jet.internal.org.jdom.input.SAXBuilder;

public class JDOMAbout {
    public static void main(String[] args) throws Exception {
        Info info = new Info();
        String title = info.title;
        System.out.println(new StringBuffer().append(title).append(" version ").append(info.version).toString());
        System.out.println(new StringBuffer().append("Copyright ").append(info.copyright).toString());
        System.out.println();
        System.out.println(info.description);
        System.out.println();
        System.out.println("Authors:");
        for (Author author : info.authors) {
            System.out.print(new StringBuffer().append("  ").append(author.name).toString());
            if (author.email == null) {
                System.out.println();
                continue;
            }
            System.out.println(new StringBuffer().append(" <").append(author.email).append(">").toString());
        }
        System.out.println();
        System.out.println(new StringBuffer().append(title).append(" license:").toString());
        System.out.println(info.license);
        System.out.println();
        System.out.println(new StringBuffer().append(title).append(" support:").toString());
        System.out.println(info.support);
        System.out.println();
        System.out.println(new StringBuffer().append(title).append(" web site: ").append(info.website).toString());
        System.out.println();
    }

    private static class Author {
        final String name;
        final String email;

        Author(String name, String email) {
            this.name = name;
            this.email = email;
        }
    }

    private static class Info {
        final String title;
        final String version;
        final String copyright;
        final String description;
        final String license;
        final String support;
        final String website;
        final List authors = new ArrayList();

        Info() throws Exception {
            InputStream inputStream = this.getInfoFileStream();
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(inputStream);
            Element root = doc.getRootElement();
            this.title = root.getChildTextTrim("title");
            this.version = root.getChildTextTrim("version");
            this.copyright = root.getChildTextTrim("copyright");
            this.description = root.getChildTextTrim("description");
            this.license = root.getChildTextTrim("license");
            this.support = root.getChildTextTrim("support");
            this.website = root.getChildTextTrim("web-site");
            List authorElements = root.getChildren("author");
            for (Element element : authorElements) {
                Author author = new Author(element.getChildTextTrim("name"), element.getChildTextTrim("e-mail"));
                this.authors.add(author);
            }
        }

        private InputStream getInfoFileStream() throws FileNotFoundException {
            InputStream inputStream = this.getClass().getResourceAsStream("META-INF/jdom-info.xml");
            if (inputStream == null) {
                throw new FileNotFoundException("META-INF/jdom-info.xml not found; it should be within the JDOM JAR but wasn't found on the classpath");
            }
            return inputStream;
        }
    }
}

