/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.jdom;

import org.jetbrains.jet.internal.org.jdom.IllegalDataException;
import org.jetbrains.jet.internal.org.jdom.Text;
import org.jetbrains.jet.internal.org.jdom.Verifier;

public class CDATA
extends Text {
    protected CDATA() {
    }

    public CDATA(String string) {
        this.setText(string);
    }

    @Override
    public Text setText(String str) {
        if (str == null || "".equals(str)) {
            this.value = "";
            return this;
        }
        String reason = Verifier.checkCDATASection(str);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value = str;
        return this;
    }

    @Override
    public void append(String str) {
        if (str == null || "".equals(str)) {
            return;
        }
        String tmpValue = this.value == "" ? str : new StringBuffer().append(this.value).append(str).toString();
        String reason = Verifier.checkCDATASection(tmpValue);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value = tmpValue;
    }

    @Override
    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.append(text.getText());
    }

    @Override
    public String toString() {
        return new StringBuffer(64).append("[CDATA: ").append(this.getText()).append("]").toString();
    }
}

