/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.jetbrains.jet.internal.org.apache.log4j.Appender;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.LogManager;
import org.jetbrains.jet.internal.org.apache.log4j.Logger;
import org.jetbrains.jet.internal.org.apache.log4j.config.PropertySetter;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.Loader;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.jet.internal.org.apache.log4j.or.RendererMap;
import org.jetbrains.jet.internal.org.apache.log4j.spi.AppenderAttachable;
import org.jetbrains.jet.internal.org.apache.log4j.spi.Configurator;
import org.jetbrains.jet.internal.org.apache.log4j.spi.ErrorHandler;
import org.jetbrains.jet.internal.org.apache.log4j.spi.Filter;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggerRepository;
import org.jetbrains.jet.internal.org.apache.log4j.spi.RendererSupport;
import org.jetbrains.jet.internal.org.apache.log4j.xml.SAXErrorHandler;
import org.jetbrains.jet.internal.org.apache.log4j.xml.XMLWatchdog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMConfigurator
implements Configurator {
    static final Class[] ONE_STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMConfigurator.class$("java.lang.String")) : class$java$lang$String};
    Hashtable appenderBag = new Hashtable();
    Properties props;
    LoggerRepository repository;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggerFactory;

    protected Appender findAppenderByName(Document doc, String appenderName) {
        Appender appender = (Appender)this.appenderBag.get(appenderName);
        if (appender != null) {
            return appender;
        }
        Element element = null;
        NodeList list = doc.getElementsByTagName("appender");
        int t = 0;
        while (t < list.getLength()) {
            Node node = list.item(t);
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem("name");
            if (appenderName.equals(attrNode.getNodeValue())) {
                element = (Element)node;
                break;
            }
            ++t;
        }
        if (element == null) {
            LogLog.error(new StringBuffer().append("No appender named [").append(appenderName).append("] could be found.").toString());
            return null;
        }
        appender = this.parseAppender(element);
        this.appenderBag.put(appenderName, appender);
        return appender;
    }

    protected Appender findAppenderByReference(Element appenderRef) {
        String appenderName = this.subst(appenderRef.getAttribute("ref"));
        Document doc = appenderRef.getOwnerDocument();
        return this.findAppenderByName(doc, appenderName);
    }

    protected Appender parseAppender(Element appenderElement) {
        String className = this.subst(appenderElement.getAttribute("class"));
        LogLog.debug(new StringBuffer().append("Class name: [").append(className).append(']').toString());
        try {
            Object instance = Loader.loadClass(className).newInstance();
            Appender appender = (Appender)instance;
            PropertySetter propSetter = new PropertySetter(appender);
            appender.setName(this.subst(appenderElement.getAttribute("name")));
            NodeList children = appenderElement.getChildNodes();
            int length = children.getLength();
            int loop = 0;
            while (loop < length) {
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() == 1) {
                    Element currentElement = (Element)currentNode;
                    if (currentElement.getTagName().equals("param")) {
                        this.setParameter(currentElement, propSetter);
                    } else if (currentElement.getTagName().equals("layout")) {
                        appender.setLayout(this.parseLayout(currentElement));
                    } else if (currentElement.getTagName().equals("filter")) {
                        this.parseFilters(currentElement, appender);
                    } else if (currentElement.getTagName().equals("errorHandler")) {
                        this.parseErrorHandler(currentElement, appender);
                    } else if (currentElement.getTagName().equals("appender-ref")) {
                        String refName = this.subst(currentElement.getAttribute("ref"));
                        if (appender instanceof AppenderAttachable) {
                            AppenderAttachable aa = (AppenderAttachable)((Object)appender);
                            LogLog.debug(new StringBuffer().append("Attaching appender named [").append(refName).append("] to appender named [").append(appender.getName()).append("].").toString());
                            aa.addAppender(this.findAppenderByReference(currentElement));
                        } else {
                            LogLog.error(new StringBuffer().append("Requesting attachment of appender named [").append(refName).append("] to appender named [").append(appender.getName()).append("] which does not implement org.apache.log4j.spi.AppenderAttachable.").toString());
                        }
                    }
                }
                ++loop;
            }
            propSetter.activate();
            return appender;
        }
        catch (Exception oops) {
            LogLog.error("Could not create an Appender. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseErrorHandler(Element element, Appender appender) {
        ErrorHandler eh = (ErrorHandler)OptionConverter.instantiateByClassName(this.subst(element.getAttribute("class")), class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.jetbrains.jet.internal.org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null);
        if (eh != null) {
            eh.setAppender(appender);
            PropertySetter propSetter = new PropertySetter(eh);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            int loop = 0;
            while (loop < length) {
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() == 1) {
                    Element currentElement = (Element)currentNode;
                    String tagName = currentElement.getTagName();
                    if (tagName.equals("param")) {
                        this.setParameter(currentElement, propSetter);
                    } else if (tagName.equals("appender-ref")) {
                        eh.setBackupAppender(this.findAppenderByReference(currentElement));
                    } else if (tagName.equals("logger-ref")) {
                        String loggerName = currentElement.getAttribute("ref");
                        Logger logger = this.repository.getLogger(loggerName);
                        eh.setLogger(logger);
                    } else if (tagName.equals("root-ref")) {
                        Logger root = this.repository.getRootLogger();
                        eh.setLogger(root);
                    }
                }
                ++loop;
            }
            propSetter.activate();
            appender.setErrorHandler(eh);
        }
    }

    protected void parseFilters(Element element, Appender appender) {
        String clazz = this.subst(element.getAttribute("class"));
        Filter filter = (Filter)OptionConverter.instantiateByClassName(clazz, class$org$apache$log4j$spi$Filter == null ? (class$org$apache$log4j$spi$Filter = DOMConfigurator.class$("org.jetbrains.jet.internal.org.apache.log4j.spi.Filter")) : class$org$apache$log4j$spi$Filter, null);
        if (filter != null) {
            PropertySetter propSetter = new PropertySetter(filter);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            int loop = 0;
            while (loop < length) {
                Element currentElement;
                String tagName;
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals("param")) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop;
            }
            propSetter.activate();
            LogLog.debug(new StringBuffer().append("Adding filter of type [").append(filter.getClass()).append("] to appender named [").append(appender.getName()).append("].").toString());
            appender.addFilter(filter);
        }
    }

    protected void parseCategory(Element loggerElement) {
        Logger cat;
        String catName = this.subst(loggerElement.getAttribute("name"));
        String className = this.subst(loggerElement.getAttribute("class"));
        if ("".equals(className)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Logger.");
            cat = this.repository.getLogger(catName);
        } else {
            LogLog.debug(new StringBuffer().append("Desired logger sub-class: [").append(className).append(']').toString());
            try {
                Class clazz = Loader.loadClass(className);
                Method getInstanceMethod = clazz.getMethod("getLogger", ONE_STRING_PARAM);
                cat = (Logger)getInstanceMethod.invoke(null, catName);
            }
            catch (Exception oops) {
                LogLog.error(new StringBuffer().append("Could not retrieve category [").append(catName).append("]. Reported error follows.").toString(), oops);
                return;
            }
        }
        Logger logger = cat;
        synchronized (logger) {
            boolean additivity = OptionConverter.toBoolean(this.subst(loggerElement.getAttribute("additivity")), true);
            LogLog.debug(new StringBuffer().append("Setting [").append(cat.getName()).append("] additivity to [").append(additivity).append("].").toString());
            cat.setAdditivity(additivity);
            this.parseChildrenOfLoggerElement(loggerElement, cat, false);
        }
    }

    protected void parseCategoryFactory(Element factoryElement) {
        String className = this.subst(factoryElement.getAttribute("class"));
        if ("".equals(className)) {
            LogLog.error("Category Factory tag class attribute not found.");
            LogLog.debug("No Category Factory configured.");
        } else {
            LogLog.debug(new StringBuffer().append("Desired category factory: [").append(className).append(']').toString());
            Object catFactory = OptionConverter.instantiateByClassName(className, class$org$apache$log4j$spi$LoggerFactory == null ? (class$org$apache$log4j$spi$LoggerFactory = DOMConfigurator.class$("org.jetbrains.jet.internal.org.apache.log4j.spi.LoggerFactory")) : class$org$apache$log4j$spi$LoggerFactory, null);
            PropertySetter propSetter = new PropertySetter(catFactory);
            Element currentElement = null;
            Node currentNode = null;
            NodeList children = factoryElement.getChildNodes();
            int length = children.getLength();
            int loop = 0;
            while (loop < length) {
                currentNode = children.item(loop);
                if (currentNode.getNodeType() == 1 && (currentElement = (Element)currentNode).getTagName().equals("param")) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop;
            }
        }
    }

    protected void parseRoot(Element rootElement) {
        Logger root;
        Logger logger = root = this.repository.getRootLogger();
        synchronized (logger) {
            this.parseChildrenOfLoggerElement(rootElement, root, true);
        }
    }

    protected void parseChildrenOfLoggerElement(Element catElement, Logger cat, boolean isRoot) {
        PropertySetter propSetter = new PropertySetter(cat);
        cat.removeAllAppenders();
        NodeList children = catElement.getChildNodes();
        int length = children.getLength();
        int loop = 0;
        while (loop < length) {
            Node currentNode = children.item(loop);
            if (currentNode.getNodeType() == 1) {
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals("appender-ref")) {
                    Element appenderRef = (Element)currentNode;
                    Appender appender = this.findAppenderByReference(appenderRef);
                    String refName = this.subst(appenderRef.getAttribute("ref"));
                    if (appender != null) {
                        LogLog.debug(new StringBuffer().append("Adding appender named [").append(refName).append("] to category [").append(cat.getName()).append("].").toString());
                    } else {
                        LogLog.debug(new StringBuffer().append("Appender named [").append(refName).append("] not found.").toString());
                    }
                    cat.addAppender(appender);
                } else if (tagName.equals("level")) {
                    this.parseLevel(currentElement, cat, isRoot);
                } else if (tagName.equals("priority")) {
                    this.parseLevel(currentElement, cat, isRoot);
                } else if (tagName.equals("param")) {
                    this.setParameter(currentElement, propSetter);
                }
            }
            ++loop;
        }
        propSetter.activate();
    }

    protected Layout parseLayout(Element layout_element) {
        String className = this.subst(layout_element.getAttribute("class"));
        LogLog.debug(new StringBuffer().append("Parsing layout of class: \"").append(className).append("\"").toString());
        try {
            Object instance = Loader.loadClass(className).newInstance();
            Layout layout = (Layout)instance;
            PropertySetter propSetter = new PropertySetter(layout);
            NodeList params = layout_element.getChildNodes();
            int length = params.getLength();
            int loop = 0;
            while (loop < length) {
                Element currentElement;
                String tagName;
                Node currentNode = params.item(loop);
                if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals("param")) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop;
            }
            propSetter.activate();
            return layout;
        }
        catch (Exception oops) {
            LogLog.error("Could not create the Layout. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseRenderer(Element element) {
        String renderingClass = this.subst(element.getAttribute("renderingClass"));
        String renderedClass = this.subst(element.getAttribute("renderedClass"));
        if (this.repository instanceof RendererSupport) {
            RendererMap.addRenderer((RendererSupport)((Object)this.repository), renderedClass, renderingClass);
        }
    }

    protected void parseLevel(Element element, Logger logger, boolean isRoot) {
        String catName = logger.getName();
        if (isRoot) {
            catName = "root";
        }
        String priStr = this.subst(element.getAttribute("value"));
        LogLog.debug(new StringBuffer().append("Level value for ").append(catName).append(" is  [").append(priStr).append("].").toString());
        if ("inherited".equalsIgnoreCase(priStr) || "null".equalsIgnoreCase(priStr)) {
            if (isRoot) {
                LogLog.error("Root level cannot be inherited. Ignoring directive.");
            } else {
                logger.setLevel(null);
            }
        } else {
            String className = this.subst(element.getAttribute("class"));
            if ("".equals(className)) {
                logger.setLevel(OptionConverter.toLevel(priStr, Level.DEBUG));
            } else {
                LogLog.debug(new StringBuffer().append("Desired Level sub-class: [").append(className).append(']').toString());
                try {
                    Class clazz = Loader.loadClass(className);
                    Method toLevelMethod = clazz.getMethod("toLevel", ONE_STRING_PARAM);
                    Level pri = (Level)toLevelMethod.invoke(null, priStr);
                    logger.setLevel(pri);
                }
                catch (Exception oops) {
                    LogLog.error(new StringBuffer().append("Could not create level [").append(priStr).append("]. Reported error follows.").toString(), oops);
                    return;
                }
            }
        }
        LogLog.debug(new StringBuffer().append(catName).append(" level set to ").append(logger.getLevel()).toString());
    }

    protected void setParameter(Element elem, PropertySetter propSetter) {
        String name = this.subst(elem.getAttribute("name"));
        String value = elem.getAttribute("value");
        value = this.subst(OptionConverter.convertSpecialChars(value));
        propSetter.setProperty(name, value);
    }

    public static void configure(Element element) {
        DOMConfigurator configurator = new DOMConfigurator();
        configurator.doConfigure(element, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String configFilename) {
        DOMConfigurator.configureAndWatch(configFilename, 60000L);
    }

    public static void configureAndWatch(String configFilename, long delay) {
        XMLWatchdog xdog = new XMLWatchdog(configFilename);
        xdog.setDelay(delay);
        xdog.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doConfigure(String filename, LoggerRepository repository) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            this.doConfigure(fis, repository);
            if (fis == null) return;
        }
        catch (IOException e) {
            LogLog.error(new StringBuffer().append("Could not open [").append(filename).append("].").toString(), e);
            return;
        }
        try {
            fis.close();
            return;
        }
        catch (IOException iOException) {
            LogLog.error(new StringBuffer().append("Could not close [").append(filename).append("].").toString(), iOException);
        }
    }

    @Override
    public void doConfigure(URL url, LoggerRepository repository) {
        try {
            this.doConfigure(url.openStream(), repository);
        }
        catch (IOException e) {
            LogLog.error(new StringBuffer().append("Could not open [").append(url).append("].").toString(), e);
        }
    }

    public void doConfigure(InputStream inputStream, LoggerRepository repository) throws FactoryConfigurationError {
        this.doConfigure(new InputSource(inputStream), repository);
    }

    public void doConfigure(Reader reader, LoggerRepository repository) throws FactoryConfigurationError {
        this.doConfigure(new InputSource(reader), repository);
    }

    protected void doConfigure(InputSource inputSource, LoggerRepository repository) throws FactoryConfigurationError {
        DocumentBuilderFactory dbf = null;
        this.repository = repository;
        try {
            LogLog.debug(new StringBuffer().append("System property is :").append(OptionConverter.getSystemProperty("javax.xml.parsers.DocumentBuilderFactory", null)).toString());
            dbf = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug(new StringBuffer().append("DocumentBuilderFactory is: ").append(dbf.getClass().getName()).toString());
        }
        catch (FactoryConfigurationError fce) {
            Exception e = fce.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", e);
            throw fce;
        }
        try {
            dbf.setValidating(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            docBuilder.setErrorHandler(new SAXErrorHandler());
            Class<?> clazz = this.getClass();
            URL dtdURL = clazz.getResource("/org/jetbrains/jet/internal/org/apache/log4j/xml/log4j.dtd");
            if (dtdURL == null) {
                LogLog.error(new StringBuffer().append("Could not find [log4j.dtd]. Used [").append(clazz.getClassLoader()).append("] class loader in the search.").toString());
            } else {
                LogLog.debug(new StringBuffer().append("URL to log4j.dtd is [").append(dtdURL.toString()).append("].").toString());
                inputSource.setSystemId(dtdURL.toString());
            }
            Document doc = docBuilder.parse(inputSource);
            this.parse(doc.getDocumentElement());
        }
        catch (Exception e) {
            LogLog.error(new StringBuffer().append("Could not parse input source [").append(inputSource).append("].").toString(), e);
        }
    }

    public void doConfigure(Element element, LoggerRepository repository) {
        this.repository = repository;
        this.parse(element);
    }

    public static void configure(String filename) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(filename, LogManager.getLoggerRepository());
    }

    public static void configure(URL url) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(url, LogManager.getLoggerRepository());
    }

    protected void parse(Element element) {
        String rootElementName = element.getTagName();
        if (!rootElementName.equals("log4j:configuration")) {
            if (rootElementName.equals("configuration")) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        String debugAttrib = this.subst(element.getAttribute("debug"));
        LogLog.debug(new StringBuffer().append("debug attribute= \"").append(debugAttrib).append("\".").toString());
        if (!debugAttrib.equals("") && !debugAttrib.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(debugAttrib, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        String confDebug = this.subst(element.getAttribute("configDebug"));
        if (!confDebug.equals("") && !confDebug.equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean(confDebug, true));
        }
        String thresholdStr = this.subst(element.getAttribute("threshold"));
        LogLog.debug(new StringBuffer().append("Threshold =\"").append(thresholdStr).append("\".").toString());
        if (!"".equals(thresholdStr) && !"null".equals(thresholdStr)) {
            this.repository.setThreshold(thresholdStr);
        }
        String tagName = null;
        Element currentElement = null;
        Node currentNode = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int loop = 0;
        while (loop < length) {
            currentNode = children.item(loop);
            if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals("categoryFactory")) {
                this.parseCategoryFactory(currentElement);
            }
            ++loop;
        }
        int loop2 = 0;
        while (loop2 < length) {
            currentNode = children.item(loop2);
            if (currentNode.getNodeType() == 1) {
                currentElement = (Element)currentNode;
                tagName = currentElement.getTagName();
                if (tagName.equals("category") || tagName.equals("logger")) {
                    this.parseCategory(currentElement);
                } else if (tagName.equals("root")) {
                    this.parseRoot(currentElement);
                } else if (tagName.equals("renderer")) {
                    this.parseRenderer(currentElement);
                }
            }
            ++loop2;
        }
    }

    protected String subst(String value) {
        try {
            return OptionConverter.substVars(value, this.props);
        }
        catch (IllegalArgumentException e) {
            LogLog.warn("Could not perform variable substitution.", e);
            return value;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

