/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.net;

import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.jetbrains.jet.internal.org.apache.log4j.Category;
import org.jetbrains.jet.internal.org.apache.log4j.Hierarchy;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.LogManager;
import org.jetbrains.jet.internal.org.apache.log4j.Priority;
import org.jetbrains.jet.internal.org.apache.log4j.PropertyConfigurator;
import org.jetbrains.jet.internal.org.apache.log4j.net.SocketNode;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggerRepository;
import org.jetbrains.jet.internal.org.apache.log4j.spi.RootCategory;

public class SocketServer {
    static String GENERIC = "generic";
    static String CONFIG_FILE_EXT = ".lcf";
    static Category cat = Category.getInstance(class$org$apache$log4j$net$SocketServer == null ? (class$org$apache$log4j$net$SocketServer = SocketServer.class$("org.jetbrains.jet.internal.org.apache.log4j.net.SocketServer")) : class$org$apache$log4j$net$SocketServer);
    static SocketServer server;
    static int port;
    Hashtable hierarchyMap;
    LoggerRepository genericHierarchy;
    File dir;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketServer;

    public static void main(String[] argv) {
        if (argv.length == 3) {
            SocketServer.init(argv[0], argv[1], argv[2]);
        } else {
            SocketServer.usage("Wrong number of arguments.");
        }
        try {
            cat.info(new StringBuffer().append("Listening on port ").append(port).toString());
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                cat.info("Waiting to accept a new client.");
                Socket socket = serverSocket.accept();
                InetAddress inetAddress = socket.getInetAddress();
                cat.info(new StringBuffer().append("Connected to client at ").append(inetAddress).toString());
                LoggerRepository h = (LoggerRepository)SocketServer.server.hierarchyMap.get(inetAddress);
                if (h == null) {
                    h = server.configureHierarchy(inetAddress);
                }
                cat.info("Starting new socket node.");
                new Thread(new SocketNode(socket, h)).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println(new StringBuffer().append("Usage: java ").append((class$org$apache$log4j$net$SocketServer == null ? (class$org$apache$log4j$net$SocketServer = SocketServer.class$("org.jetbrains.jet.internal.org.apache.log4j.net.SocketServer")) : class$org$apache$log4j$net$SocketServer).getName()).append(" port configFile directory").toString());
        System.exit(1);
    }

    static void init(String portStr, String configFile, String dirStr) {
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            SocketServer.usage(new StringBuffer().append("Could not interpret port number [").append(portStr).append("].").toString());
        }
        PropertyConfigurator.configure(configFile);
        File dir = new File(dirStr);
        if (!dir.isDirectory()) {
            SocketServer.usage(new StringBuffer().append("[").append(dirStr).append("] is not a directory.").toString());
        }
        server = new SocketServer(dir);
    }

    public SocketServer(File directory) {
        this.dir = directory;
        this.hierarchyMap = new Hashtable(11);
    }

    LoggerRepository configureHierarchy(InetAddress inetAddress) {
        cat.info(new StringBuffer().append("Locating configuration file for ").append(inetAddress).toString());
        String s = inetAddress.toString();
        int i = s.indexOf("/");
        if (i == -1) {
            cat.warn(new StringBuffer().append("Could not parse the inetAddress [").append(inetAddress).append("]. Using default hierarchy.").toString());
            return this.genericHierarchy();
        }
        String key = s.substring(0, i);
        File configFile = new File(this.dir, new StringBuffer().append(key).append(CONFIG_FILE_EXT).toString());
        if (configFile.exists()) {
            Hierarchy h = new Hierarchy(new RootCategory((Level)Priority.DEBUG));
            this.hierarchyMap.put(inetAddress, h);
            new PropertyConfigurator().doConfigure(configFile.getAbsolutePath(), (LoggerRepository)h);
            return h;
        }
        cat.warn(new StringBuffer().append("Could not find config file [").append(configFile).append("].").toString());
        return this.genericHierarchy();
    }

    LoggerRepository genericHierarchy() {
        if (this.genericHierarchy == null) {
            File f = new File(this.dir, new StringBuffer().append(GENERIC).append(CONFIG_FILE_EXT).toString());
            if (f.exists()) {
                this.genericHierarchy = new Hierarchy(new RootCategory((Level)Priority.DEBUG));
                new PropertyConfigurator().doConfigure(f.getAbsolutePath(), this.genericHierarchy);
            } else {
                cat.warn(new StringBuffer().append("Could not find config file [").append(f).append("]. Will use the default hierarchy.").toString());
                this.genericHierarchy = LogManager.getLoggerRepository();
            }
        }
        return this.genericHierarchy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

