/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.net;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;
import org.jetbrains.jet.internal.org.apache.log4j.Logger;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggerRepository;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggingEvent;

public class SocketNode
implements Runnable {
    Socket socket;
    LoggerRepository hierarchy;
    ObjectInputStream ois;
    static Logger logger = Logger.getLogger(class$org$apache$log4j$net$SocketNode == null ? (class$org$apache$log4j$net$SocketNode = SocketNode.class$("org.jetbrains.jet.internal.org.apache.log4j.net.SocketNode")) : class$org$apache$log4j$net$SocketNode);
    static /* synthetic */ Class class$org$apache$log4j$net$SocketNode;

    public SocketNode(Socket socket, LoggerRepository hierarchy) {
        this.socket = socket;
        this.hierarchy = hierarchy;
        try {
            this.ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (Exception e) {
            logger.error(new StringBuffer().append("Could not open ObjectInputStream to ").append(socket).toString(), e);
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                LoggingEvent event = (LoggingEvent)this.ois.readObject();
                Logger remoteLogger = this.hierarchy.getLogger(event.categoryName);
                event.logger = remoteLogger;
                if (!event.level.isGreaterOrEqual(remoteLogger.getEffectiveLevel())) continue;
                remoteLogger.callAppenders(event);
            }
        }
        catch (EOFException e) {
            logger.info("Caught java.io.EOFException closing conneciton.");
        }
        catch (SocketException e) {
            logger.info("Caught java.net.SocketException closing conneciton.");
        }
        catch (IOException e) {
            logger.info(new StringBuffer().append("Caught java.io.IOException: ").append(e).toString());
            logger.info("Closing connection.");
        }
        catch (Exception e) {
            logger.error("Unexpected exception. Closing conneciton.", e);
        }
        try {
            this.ois.close();
        }
        catch (Exception e) {
            logger.info("Could not close connection.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

