/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.net;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.jetbrains.jet.internal.org.apache.log4j.AppenderSkeleton;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggingEvent;

public class SocketAppender
extends AppenderSkeleton {
    String remoteHost;
    InetAddress address;
    int port = 4560;
    ObjectOutputStream oos;
    int reconnectionDelay = 30000;
    boolean locationInfo = false;
    private Connector connector;
    int counter = 0;

    public SocketAppender() {
    }

    public SocketAppender(InetAddress address, int port) {
        this.address = address;
        this.remoteHost = address.getHostName();
        this.port = port;
        this.connect(address, port);
    }

    public SocketAppender(String host, int port) {
        this.port = port;
        this.address = SocketAppender.getAddressByName(host);
        this.remoteHost = host;
        this.connect(this.address, port);
    }

    @Override
    public void activateOptions() {
        this.connect(this.address, this.port);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                LogLog.error("Could not close oos.", e);
            }
            this.oos = null;
        }
        if (this.connector != null) {
            this.connector.interrupted = true;
            this.connector = null;
        }
    }

    void connect(InetAddress address, int port) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(new Socket(address, port).getOutputStream());
        }
        catch (IOException e) {
            LogLog.error(new StringBuffer().append("Could not connect to remote log4j server at [").append(address.getHostName()).append("]. We will try again later.").toString(), e);
            this.fireConnector();
        }
    }

    @Override
    public void append(LoggingEvent event) {
        block7: {
            if (event == null) {
                return;
            }
            if (this.address == null) {
                this.errorHandler.error(new StringBuffer().append("No remote host is set for SocketAppender named \"").append(this.name).append("\".").toString());
                return;
            }
            if (this.oos != null) {
                try {
                    if (this.locationInfo) {
                        event.getLocationInformation();
                    }
                    this.oos.writeObject(event);
                    this.oos.flush();
                    if (++this.counter >= 1) {
                        this.counter = 0;
                        this.oos.reset();
                    }
                }
                catch (IOException e) {
                    this.oos = null;
                    LogLog.warn(new StringBuffer().append("Detected problem with connection: ").append(e).toString());
                    if (this.reconnectionDelay <= 0) break block7;
                    this.fireConnector();
                }
            }
        }
    }

    void fireConnector() {
        if (this.connector == null) {
            LogLog.debug("Starting a new connector thread.");
            this.connector = new Connector();
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    static InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            LogLog.error(new StringBuffer().append("Could not find address of [").append(host).append("].").toString(), e);
            return null;
        }
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }

    public void setRemoteHost(String host) {
        this.address = SocketAppender.getAddressByName(host);
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setReconnectionDelay(int delay) {
        this.reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    class Connector
    extends Thread {
        boolean interrupted = false;

        Connector() {
        }

        @Override
        public void run() {
            while (!this.interrupted) {
                try {
                    Thread.sleep(SocketAppender.this.reconnectionDelay);
                    LogLog.debug(new StringBuffer().append("Attempting connection to ").append(SocketAppender.this.address.getHostName()).toString());
                    Socket socket = new Socket(SocketAppender.this.address, SocketAppender.this.port);
                    Connector connector = this;
                    synchronized (connector) {
                        SocketAppender.this.oos = new ObjectOutputStream(socket.getOutputStream());
                        SocketAppender.this.connector = null;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    LogLog.debug("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException e) {
                    LogLog.debug(new StringBuffer().append("Remote host ").append(SocketAppender.this.address.getHostName()).append(" refused connection.").toString());
                }
                catch (IOException e) {
                    LogLog.debug(new StringBuffer().append("Could not connect to ").append(SocketAppender.this.address.getHostName()).append(". Exception is ").append(e).toString());
                }
            }
        }
    }
}

